/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class BlindingBatEntity
extends Bat {
    private final TargetingConditions nonVampirePredicatePlayer = TargetingConditions.m_148352_().m_26888_(VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true).and(EntitySelector.f_20406_));
    private final TargetingConditions nonVampirePredicate = TargetingConditions.m_148352_().m_26888_(e -> !Helper.isVampire((Entity)e));
    private boolean restrictLiveSpan;
    private boolean targeting;
    private boolean targetingMob = false;

    public static boolean spawnPredicate(EntityType<? extends BlindingBatEntity> entityType, LevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        if (iWorld.m_204166_(blockPos).m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME)) {
            return true;
        }
        if (blockPos.m_123342_() >= iWorld.m_5736_()) {
            return false;
        }
        int i = iWorld.m_46803_(blockPos);
        int j = 4;
        if (random.nextBoolean()) {
            return false;
        }
        return i <= random.nextInt(j) && BlindingBatEntity.m_21400_(entityType, (LevelAccessor)iWorld, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    public BlindingBatEntity(EntityType<? extends BlindingBatEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public boolean m_5545_(LevelAccessor worldIn, @Nonnull MobSpawnType spawnReasonIn) {
        return worldIn.m_5450_((Entity)this, Shapes.m_83064_((AABB)this.m_142469_())) && worldIn.m_45784_((Entity)this) && !worldIn.m_46855_(this.m_142469_());
    }

    public void restrictLiveSpan() {
        this.restrictLiveSpan = true;
    }

    public void setTargeting() {
        this.targeting = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.restrictLiveSpan && this.f_19797_ > BalanceMobProps.mobProps.BLINDING_BAT_LIVE_SPAWN) {
            this.m_6469_(DamageSource.f_19319_, 10.0f);
        }
        if (!this.f_19853_.f_46443_) {
            List l = this.targetingMob ? this.f_19853_.m_45976_(Monster.class, this.m_142469_()) : this.f_19853_.m_45976_(Player.class, this.m_142469_());
            boolean hit = false;
            for (LivingEntity e : l) {
                if (!e.m_6084_() || Helper.isVampire((Entity)e)) continue;
                e.m_7292_(new MobEffectInstance(MobEffects.f_19610_, BalanceMobProps.mobProps.BLINDING_BAT_EFFECT_DURATION));
                hit = true;
            }
            if (this.targeting && hit) {
                this.m_6469_(DamageSource.f_19318_, 1000.0f);
            }
        }
    }

    protected void m_8024_() {
        boolean t = false;
        if (this.targeting && this.f_19797_ > 40) {
            Vec3 diff;
            double dist;
            this.targetingMob = false;
            Player e = this.f_19853_.m_45946_(this.nonVampirePredicatePlayer, (LivingEntity)this);
            if (e == null) {
                e = this.f_19853_.m_45963_(Monster.class, this.nonVampirePredicate, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142469_().m_82400_(20.0));
                this.targetingMob = true;
            }
            if (e != null && (dist = (diff = e.m_20182_().m_82520_(0.0, (double)e.m_20192_(), 0.0).m_82546_(this.m_20182_())).m_82553_()) < 20.0) {
                Vec3 mov = diff.m_82490_(0.15 / dist);
                this.m_20256_(mov);
                float f = (float)(Mth.m_14136_((double)mov.f_82481_, (double)mov.f_82479_) * 57.2957763671875) - 90.0f;
                float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
                this.f_20902_ = 0.5f;
                this.m_146922_(this.m_146908_() + f1);
                t = true;
            }
        }
        if (!t) {
            super.m_8024_();
        }
    }
}

