/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class AlchemicalCauldronRecipeBuilder {
    private final ItemStack result;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;
    private Ingredient ingredient;
    private Either<Ingredient, FluidStack> fluid;
    private ISkill<?>[] skills;
    private int reqLevel = 1;
    private int cookTime = 200;
    private float exp = 0.2f;

    public static AlchemicalCauldronRecipeBuilder cauldronRecipe(Item item) {
        return AlchemicalCauldronRecipeBuilder.cauldronRecipe(item, 1);
    }

    public static AlchemicalCauldronRecipeBuilder cauldronRecipe(Item item, int count) {
        return new AlchemicalCauldronRecipeBuilder(item, count);
    }

    public AlchemicalCauldronRecipeBuilder(Item result, int count) {
        this.result = new ItemStack((ItemLike)result, count);
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ISkill<?>[] iSkillArray;
        id = new ResourceLocation(id.m_135827_(), "alchemical_cauldron/" + id.m_135815_());
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        String string = this.group != null ? this.group : "";
        if (this.skills != null) {
            iSkillArray = this.skills;
        } else {
            ISkill[] iSkillArray2 = new ISkill[1];
            iSkillArray = iSkillArray2;
            iSkillArray2[0] = HunterSkills.basic_alchemy;
        }
        consumer.accept(new Result(id, string, this.ingredient, this.fluid, this.result, iSkillArray, this.reqLevel, this.cookTime, this.exp, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_())));
    }

    public AlchemicalCauldronRecipeBuilder cookTime(int cookTime) {
        this.cookTime = cookTime;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder experience(float exp) {
        this.exp = exp;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder requireLevel(int level) {
        this.reqLevel = level;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(TagKey<Item> tag) {
        this.fluid = Either.left((Object)Ingredient.m_204132_(tag));
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(FluidStack fluid) {
        this.fluid = Either.right((Object)fluid);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(ItemLike ... item) {
        this.fluid = Either.left((Object)Ingredient.m_43929_((ItemLike[])item));
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(ItemStack ... stacks) {
        this.fluid = Either.left((Object)Ingredient.m_43927_((ItemStack[])stacks));
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withIngredient(ItemLike ... items) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])items);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withIngredient(ItemStack ... stacks) {
        this.ingredient = Ingredient.m_43927_((ItemStack[])stacks);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withIngredient(TagKey<Item> tag) {
        this.ingredient = Ingredient.m_204132_(tag);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withSkills(ISkill<?> ... skills) {
        this.skills = skills;
        return this;
    }

    private void validate(ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredients defined for alchemical cauldron recipe " + id + "!");
        }
        if (this.fluid == null) {
            throw new IllegalStateException("No fluid defined for alchemical cauldron recipe " + id + "!");
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Either<Ingredient, FluidStack> fluid;
        private final ItemStack result;
        private final ISkill<?>[] skills;
        private final int reqLevel;
        private final int cookTimeIn;
        private final float exp;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(@Nonnull ResourceLocation idIn, @Nonnull String groupIn, @Nonnull Ingredient ingredientIn, @Nonnull Either<Ingredient, FluidStack> fluidIn, @Nonnull ItemStack resultIn, @Nonnull ISkill<?>[] skillsIn, int reqLevelIn, int cookTimeIn, float exp, Advancement.Builder advancementBuilderIn, ResourceLocation advancementId) {
            this.id = idIn;
            this.group = groupIn;
            this.ingredient = ingredientIn;
            this.fluid = fluidIn;
            this.result = resultIn;
            this.skills = skillsIn;
            this.reqLevel = reqLevelIn;
            this.cookTimeIn = cookTimeIn;
            this.exp = exp;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementId;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.alchemical_cauldron;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        public void m_7917_(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonObject result = new JsonObject();
            result.addProperty("item", this.result.m_41720_().getRegistryName().toString());
            if (this.result.m_41613_() > 1) {
                result.addProperty("count", (Number)this.result.m_41613_());
            }
            jsonObject.add("result", (JsonElement)result);
            jsonObject.add("ingredient", this.ingredient.m_43942_());
            this.fluid.ifLeft(ingredient1 -> jsonObject.add("fluidItem", ingredient1.m_43942_()));
            this.fluid.ifRight(fluidStack -> {
                JsonObject fluid = new JsonObject();
                fluid.addProperty("fluid", fluidStack.getFluid().getRegistryName().toString());
                jsonObject.add("fluid", (JsonElement)fluid);
            });
            JsonArray skills = new JsonArray();
            for (ISkill<?> skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            jsonObject.add("skill", (JsonElement)skills);
            jsonObject.addProperty("cookTime", (Number)this.cookTimeIn);
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.exp));
            jsonObject.addProperty("reqLevel", (Number)this.reqLevel);
        }
    }
}

