/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.GarlicBlock;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.world.loot.AddBookNbt;
import de.teamlapen.vampirism.world.loot.AdjustableLevelCondition;
import de.teamlapen.vampirism.world.loot.RefinementSetFunction;
import de.teamlapen.vampirism.world.loot.SetItemBloodCharge;
import de.teamlapen.vampirism.world.loot.StakeCondition;
import de.teamlapen.vampirism.world.loot.TentSpawnerCondition;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTablesGenerator
extends LootTableProvider {
    public static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public LootTablesGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(ModEntityLootTables::new, (Object)LootContextParamSets.f_81415_), (Object)Pair.of(ModChestLootTables::new, (Object)LootContextParamSets.f_81411_), (Object)Pair.of(ModBlockLootTables::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(InjectLootTables::new, (Object)LootContextParamSets.f_81411_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
        for (ResourceLocation resourcelocation : Sets.difference(ModLootTables.getLootTables(), map.keySet())) {
            validationtracker.m_79357_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((resourceLocation, lootTable) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    private static class InjectLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private InjectLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.abandoned_mineshaft, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)4.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_fang).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.blood_bottle).m_79707_(15).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(5).m_5577_(AddBookNbt.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_head_ultimate).m_79707_(3).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_chest_ultimate).m_79707_(3).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_legs_ultimate).m_79707_(3).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_feet_ultimate).m_79707_(3).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(88))).m_79161_(LootPool.m_79043_().name("hunter_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_axe_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95))).m_79161_(LootPool.m_79043_().name("vampire_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_seeker_enhanced).m_79707_(20).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_striker_enhanced).m_79707_(20).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("holy_Water").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_salt).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_normal).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_enhanced).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_ultimate).m_79707_(10))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.desert_pyramid, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.blood_bottle).m_79707_(20).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.6f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(8).m_5577_(AddBookNbt.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("obsidian_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_head_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_chest_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_legs_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_feet_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.jungle_temple, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.blood_bottle).m_79707_(20).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(20).m_5577_(AddBookNbt.builder())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_fang).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(30))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_head_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_chest_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_legs_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_feet_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("hunter_coat").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_head_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_chest_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_legs_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_feet_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.stronghold_corridor, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(20).m_5577_(AddBookNbt.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(27))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_head_ultimate).m_79707_(5).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_chest_ultimate).m_79707_(5).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_legs_ultimate).m_79707_(5).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_feet_ultimate).m_79707_(5).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(80))).m_79161_(LootPool.m_79043_().name("obsidian_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_head_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_chest_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_legs_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_feet_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("vampire_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_seeker_enhanced).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_striker_enhanced).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(80))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
            consumer.accept(ModLootTables.stronghold_library, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(1).m_5577_(AddBookNbt.builder()))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
        }
    }

    private static class ModBlockLootTables
    extends BlockLoot {
        private ModBlockLootTables() {
        }

        protected void addTables() {
            this.m_124288_((Block)ModBlocks.alchemical_cauldron);
            this.m_124288_((Block)ModBlocks.altar_infusion);
            this.m_124288_((Block)ModBlocks.altar_inspiration);
            this.m_124165_(ModBlocks.altar_pillar, ModBlockLootTables.m_124126_((ItemLike)ModBlocks.altar_pillar).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ExplosionCondition.m_81661_()).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42018_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)ModBlocks.altar_pillar).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "stone")))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_41913_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)ModBlocks.altar_pillar).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "iron")))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_41912_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)ModBlocks.altar_pillar).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "gold")))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42262_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)ModBlocks.altar_pillar).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(AltarPillarBlock.TYPE_PROPERTY, "bone"))))));
            this.m_124288_(ModBlocks.altar_tip);
            this.m_124175_((Block)ModBlocks.coffin, block -> ModBlockLootTables.m_124161_((Block)block, CoffinBlock.PART, (Comparable)((Object)CoffinBlock.CoffinPart.HEAD)));
            this.m_124288_((Block)ModBlocks.blood_container);
            this.m_124288_((Block)ModBlocks.blood_grinder);
            this.m_124288_((Block)ModBlocks.blood_pedestal);
            this.m_124288_((Block)ModBlocks.potion_table);
            this.m_124288_((Block)ModBlocks.blood_sieve);
            this.m_124288_(ModBlocks.castle_block_dark_brick);
            this.m_124288_(ModBlocks.castle_block_dark_brick_bloody);
            this.m_124288_(ModBlocks.castle_block_dark_stone);
            this.m_124288_(ModBlocks.castle_block_normal_brick);
            this.m_124288_(ModBlocks.castle_block_purple_brick);
            this.m_124288_((Block)ModBlocks.castle_slab_dark_brick);
            this.m_124288_((Block)ModBlocks.castle_slab_dark_stone);
            this.m_124288_((Block)ModBlocks.castle_slab_purple_brick);
            this.m_124288_((Block)ModBlocks.castle_stairs_dark_brick);
            this.m_124288_((Block)ModBlocks.castle_stairs_dark_stone);
            this.m_124288_((Block)ModBlocks.castle_stairs_purple_brick);
            this.m_124288_(ModBlocks.altar_cleansing);
            this.m_124288_(ModBlocks.cursed_earth);
            this.m_124288_(ModBlocks.fire_place);
            this.m_124165_((Block)ModBlocks.garlic, (LootTable.Builder)ModBlockLootTables.m_124131_((ItemLike)ModBlocks.garlic, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic))).m_79161_(LootPool.m_79043_().m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)ModBlocks.garlic).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)GarlicBlock.f_52244_, 7))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))))));
            this.m_124288_((Block)ModBlocks.garlic_diffuser_weak);
            this.m_124288_((Block)ModBlocks.garlic_diffuser_normal);
            this.m_124288_((Block)ModBlocks.garlic_diffuser_improved);
            this.m_124288_(ModBlocks.hunter_table);
            this.m_124175_(ModBlocks.med_chair, block -> LootTable.m_79147_().m_79161_((LootPool.Builder)ModBlockLootTables.m_124134_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)ModItems.item_med_chair).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(MedChairBlock.PART, (Comparable)((Object)MedChairBlock.EnumPart.TOP))))))));
            this.m_124288_((Block)ModBlocks.sunscreen_beacon);
            this.m_124165_(ModBlocks.tent_main, ModBlockLootTables.m_124126_((ItemLike)ModItems.item_tent).m_79161_(LootPool.m_79043_().name("bonus").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(TentSpawnerCondition.builder()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42410_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42406_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50705_))));
            this.m_124288_(ModBlocks.totem_base);
            this.m_124288_((Block)ModBlocks.totem_top_crafted);
            this.m_124165_((Block)ModBlocks.totem_top_vampirism_vampire_crafted, ModBlockLootTables.m_124126_((ItemLike)ModBlocks.totem_top_crafted));
            this.m_124165_((Block)ModBlocks.totem_top_vampirism_hunter_crafted, ModBlockLootTables.m_124126_((ItemLike)ModBlocks.totem_top_crafted));
            this.m_124165_((Block)ModBlocks.totem_top, ModBlockLootTables.m_124125_());
            this.m_124165_((Block)ModBlocks.totem_top_vampirism_hunter, ModBlockLootTables.m_124125_());
            this.m_124165_((Block)ModBlocks.totem_top_vampirism_vampire, ModBlockLootTables.m_124125_());
            this.m_124288_((Block)ModBlocks.vampire_orchid);
            this.m_124288_(ModBlocks.weapon_table);
            this.m_124165_(ModBlocks.tent, ModBlockLootTables.m_124125_());
            this.m_124252_((Block)ModBlocks.potted_vampire_orchid);
            this.m_124288_((Block)ModBlocks.bloody_spruce_sapling);
            this.m_124288_((Block)ModBlocks.vampire_spruce_sapling);
            this.m_124288_((Block)ModBlocks.bloody_spruce_log);
            this.m_124175_((Block)ModBlocks.vampire_spruce_leaves, block -> ModBlockLootTables.m_124157_((Block)block, (Block)ModBlocks.vampire_spruce_sapling, (float[])DEFAULT_SAPLING_DROP_RATES));
            this.m_124175_((Block)ModBlocks.bloody_spruce_leaves, block -> ModBlockLootTables.m_124157_((Block)block, (Block)ModBlocks.bloody_spruce_sapling, (float[])DEFAULT_SAPLING_DROP_RATES));
            this.m_124288_(ModBlocks.chandelier);
            this.m_124165_(ModBlocks.candelabra_wall, ModBlockLootTables.m_124126_((ItemLike)ModItems.item_candelabra));
            this.m_124165_(ModBlocks.candelabra, ModBlockLootTables.m_124126_((ItemLike)ModItems.item_candelabra));
            this.m_124288_(ModBlocks.cross);
            this.m_124288_(ModBlocks.tombstone1);
            this.m_124288_(ModBlocks.tombstone2);
            this.m_124288_(ModBlocks.tombstone3);
            this.m_124288_(ModBlocks.grave_cage);
            this.m_124165_((Block)ModBlocks.cursed_grass_block, ModBlockLootTables.m_124126_((ItemLike)ModBlocks.cursed_earth));
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.getAllBlocks();
        }
    }

    private static class ModChestLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private ModChestLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.chest_hunter_trainer, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)9.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_blood_bottle).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_79707_(40))).m_79161_(LootPool.m_79043_().name("book").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(50).m_5577_(AddBookNbt.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95))).m_79161_(LootPool.m_79043_().name("hunter_weapons").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_axe_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95))).m_79161_(LootPool.m_79043_().name("swiftness_armor").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_head_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_chest_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_legs_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.armor_of_swiftness_feet_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("hunter_coat").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_head_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_chest_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_legs_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.hunter_coat_feet_ultimate).m_79707_(10).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60))).m_79161_(LootPool.m_79043_().name("obsidian").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_head_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_chest_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_legs_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obsidian_armor_feet_ultimate).m_79707_(7).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(72))).m_79161_(LootPool.m_79043_().name("holy_water").m_165133_((NumberProvider)ConstantValue.m_165692_((float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_salt).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_normal).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_enhanced).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_ultimate).m_79707_(10))));
            consumer.accept(ModLootTables.chest_vampire_dungeon, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)7.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_fang).m_79707_(35)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.blood_bottle).m_79707_(20).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().name("book").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(70).m_5577_(AddBookNbt.builder())).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(30))).m_79161_(LootPool.m_79043_().name("equipment").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_seeker_enhanced).m_79707_(21).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_5577_(SetItemBloodCharge.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_seeker_ultimate).m_79707_(9).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_5577_(SetItemBloodCharge.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_striker_enhanced).m_79707_(21).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_5577_(SetItemBloodCharge.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.heart_striker_ultimate).m_79707_(9).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.99f))).m_5577_(SetItemBloodCharge.builder((NumberProvider)UniformGenerator.m_165780_((float)500.0f, (float)2000.0f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION)))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLoot {
        private ModEntityLootTables() {
        }

        protected void addTables() {
            CompoundTag splash = new CompoundTag();
            splash.m_128379_("splash", true);
            LootTable.Builder advanced_hunter = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_blood_bottle).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.item_garlic).m_79707_(4).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_enhanced).m_79707_(3).m_5577_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)splash))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_water_bottle_ultimate).m_79707_(1).m_5577_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)splash))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_salt).m_79707_(4).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79161_(LootPool.m_79043_().name("special").m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.05f, (float)0.01f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(1).m_5577_(AddBookNbt.builder())));
            this.m_124371_(ModEntities.advanced_hunter, advanced_hunter);
            this.m_124371_(ModEntities.advanced_hunter_imob, advanced_hunter);
            LootTable.Builder advanced_vampire = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_blood_bottle).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.blood_bottle).m_79707_(1).m_5577_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.5f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().name("special").m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.1f, (float)0.01f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_book).m_79707_(1).m_5577_(AddBookNbt.builder()))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.05f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.m_124371_(ModEntities.advanced_vampire, advanced_vampire);
            this.m_124371_(ModEntities.advanced_vampire_imob, advanced_vampire);
            this.m_124371_(ModEntities.blinding_bat, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_creature, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_creature_imob, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_sheep, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_cow, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_horse, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_donkey, LootTable.m_79147_());
            this.m_124371_(ModEntities.converted_mule, LootTable.m_79147_());
            this.m_124371_(ModEntities.dummy_creature, LootTable.m_79147_());
            this.m_124371_(ModEntities.hunter_trainer, LootTable.m_79147_());
            LootTable.Builder vampire = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.33f, (float)0.05f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_fang).m_79707_(1))).m_79161_(LootPool.m_79043_().name("special").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(StakeCondition.builder(LootContext.EntityTarget.KILLER_PLAYER)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.5f, (float)0.05f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.vampire_blood_bottle).m_79707_(1))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.02f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.m_124371_(ModEntities.vampire, vampire);
            this.m_124371_(ModEntities.vampire_imob, vampire);
            this.m_124371_(ModEntities.vampire_baron, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("pure_blood_0").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(AdjustableLevelCondition.builder(0, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.pure_blood_0).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_1").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(AdjustableLevelCondition.builder(1, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.pure_blood_1).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_2").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(AdjustableLevelCondition.builder(2, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.pure_blood_2).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_3").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(AdjustableLevelCondition.builder(3, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.pure_blood_3).m_79707_(1))).m_79161_(LootPool.m_79043_().name("pure_blood_4").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(AdjustableLevelCondition.builder(4, LootContext.EntityTarget.THIS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.pure_blood_4).m_79707_(1))));
            LootTable.Builder hunter = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("general").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.33f, (float)0.005f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.human_heart).m_79707_(1))).m_79161_(LootPool.m_79043_().name("special").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.25f, (float)0.05f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.holy_salt).m_79707_(1))).m_79161_(LootPool.m_79043_().name("refinement_item").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.05f, (float)0.02f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.amulet).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ring).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.obi_belt).m_79707_(1).m_5577_(RefinementSetFunction.builder(VReference.VAMPIRE_FACTION))));
            this.m_124371_(ModEntities.hunter, hunter);
            this.m_124371_(ModEntities.hunter_imob, hunter);
            this.m_124371_(ModEntities.villager_angry, LootTable.m_79147_());
            this.m_124371_(ModEntities.villager_converted, LootTable.m_79147_());
            this.m_124371_(ModEntities.task_master_vampire, LootTable.m_79147_());
            this.m_124371_(ModEntities.task_master_hunter, LootTable.m_79147_());
            this.m_124371_(ModEntities.vampire_minion, LootTable.m_79147_());
            this.m_124371_(ModEntities.hunter_minion, LootTable.m_79147_());
        }

        @Nonnull
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModEntities.getAllEntities();
        }
    }
}

