/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.FactionVillagerProfession;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.entity.villager.VampireVillagerHostilesSensor;
import de.teamlapen.vampirism.world.FactionPointOfInterestType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="vampirism")
public class ModVillage {
    public static final VillagerProfession hunter_expert = (VillagerProfession)UtilLib.getNull();
    public static final VillagerProfession vampire_expert = (VillagerProfession)UtilLib.getNull();
    public static final FactionPointOfInterestType no_faction = (FactionPointOfInterestType)((Object)UtilLib.getNull());
    public static final FactionPointOfInterestType hunter_faction = (FactionPointOfInterestType)((Object)UtilLib.getNull());
    public static final FactionPointOfInterestType vampire_faction = (FactionPointOfInterestType)((Object)UtilLib.getNull());
    public static final Schedule converted_default = (Schedule)UtilLib.getNull();
    public static final SensorType<VampireVillagerHostilesSensor> vampire_villager_hostiles = (SensorType)UtilLib.getNull();

    static void registerProfessions(IForgeRegistry<VillagerProfession> registry) {
        VillagerProfession vampire_expert = (VillagerProfession)new FactionVillagerProfession("vampire_expert", (PoiType)vampire_faction, ImmutableSet.of(), ImmutableSet.of(), null){

            @Override
            public IFaction<?> getFaction() {
                return VReference.VAMPIRE_FACTION;
            }
        }.setRegistryName("vampirism", "vampire_expert");
        VillagerProfession hunter_expert = (VillagerProfession)new FactionVillagerProfession("hunter_expert", (PoiType)hunter_faction, ImmutableSet.of(), ImmutableSet.of(), null){

            @Override
            public IFaction<?> getFaction() {
                return VReference.HUNTER_FACTION;
            }
        }.setRegistryName("vampirism", "hunter_expert");
        registry.register((IForgeRegistryEntry)vampire_expert);
        registry.register((IForgeRegistryEntry)hunter_expert);
        VillagerTrades.f_35627_.computeIfAbsent(hunter_expert, trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getHunterTrades());
        VillagerTrades.f_35627_.computeIfAbsent(vampire_expert, trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getVampireTrades());
    }

    static void registerVillagePointOfInterestType(IForgeRegistry<PoiType> registry) {
        PoiType hunter_faction = (PoiType)new FactionPointOfInterestType("hunter_faction", ModVillage.getAllStates(new Block[]{ModBlocks.totem_top_vampirism_hunter, ModBlocks.totem_top_vampirism_hunter_crafted}), 1, 1).setRegistryName("vampirism", "hunter_faction");
        PoiType vampire_faction = (PoiType)new FactionPointOfInterestType("vampire_faction", ModVillage.getAllStates(new Block[]{ModBlocks.totem_top_vampirism_vampire, ModBlocks.totem_top_vampirism_vampire_crafted}), 1, 1).setRegistryName("vampirism", "vampire_faction");
        PoiType no_faction = (PoiType)new FactionPointOfInterestType("no_faction", ModVillage.getAllStates(new Block[]{ModBlocks.totem_top, ModBlocks.totem_top_crafted}), 1, 1).setRegistryName("vampirism", "no_faction");
        registry.register((IForgeRegistryEntry)hunter_faction);
        registry.register((IForgeRegistryEntry)vampire_faction);
        registry.register((IForgeRegistryEntry)no_faction);
        PoiType.m_27367_((PoiType)hunter_faction);
        PoiType.m_27367_((PoiType)vampire_faction);
        PoiType.m_27367_((PoiType)no_faction);
    }

    static void registerSensor(IForgeRegistry<SensorType<?>> registry) {
        registry.register((IForgeRegistryEntry)((SensorType)new SensorType(VampireVillagerHostilesSensor::new).setRegistryName("vampirism", "vampire_villager_hostiles")));
    }

    static void registerSchedule(IForgeRegistry<Schedule> registry) {
        registry.register((IForgeRegistryEntry)((Schedule)new ScheduleBuilder(new Schedule()).m_38040_(12000, Activity.f_37979_).m_38040_(10, Activity.f_37982_).m_38040_(14000, Activity.f_37980_).m_38040_(21000, Activity.f_37983_).m_38040_(23000, Activity.f_37979_).m_38039_().setRegistryName("vampirism", "converted_default")));
    }

    private static Set<BlockState> getAllStates(Block ... blocks) {
        return (Set)Arrays.stream(blocks).map(block -> (BlockState)block.m_49965_().m_61090_()).collect(ImmutableSet.toImmutableSet());
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> getHunterTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(10, 20), ModItems.item_garlic, new Trades.Price(2, 5)), new Trades.ItemsForSouls(new Trades.Price(30, 40), ModItems.armor_of_swiftness_chest_normal, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), ModItems.armor_of_swiftness_legs_normal, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), ModItems.armor_of_swiftness_feet_normal, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.armor_of_swiftness_head_normal, new Trades.Price(1, 1), 6, 1), new Trades.BiomeMapForEmeralds(5, ModBiomes.VAMPIRE_FOREST, 3, 2)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(25, 45), (ItemLike)Items.f_42415_, new Trades.Price(1, 1), 2, 5), new Trades.ItemsForSouls(new Trades.Price(10, 20), ModItems.crossbow_arrow_normal, new Trades.Price(5, 15)), new VillagerTrades.ItemsForEmeralds((Item)ModItems.soul_orb_vampire, 10, 10, 4), new Trades.ItemsForSouls(new Trades.Price(30, 40), ModItems.hunter_coat_chest_normal, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), ModItems.hunter_coat_legs_normal, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), ModItems.hunter_coat_feet_normal, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.hunter_coat_head_normal, new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 40), ModItems.armor_of_swiftness_chest_enhanced, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), ModItems.armor_of_swiftness_legs_enhanced, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), ModItems.armor_of_swiftness_feet_enhanced, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.armor_of_swiftness_head_enhanced, new Trades.Price(1, 1), 6, 1)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(40, 64), (ItemLike)ModItems.vampire_book, new Trades.Price(1, 1), 10, 1), new Trades.ItemsForSouls(new Trades.Price(10, 20), ModItems.holy_water_bottle_enhanced, new Trades.Price(1, 3)), new Trades.ItemsForSouls(new Trades.Price(30, 40), ModItems.obsidian_armor_chest_normal, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), ModItems.obsidian_armor_legs_normal, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), ModItems.obsidian_armor_feet_normal, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.obsidian_armor_head_normal, new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 40), ModItems.hunter_coat_chest_enhanced, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), ModItems.hunter_coat_legs_enhanced, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), ModItems.hunter_coat_feet_enhanced, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.hunter_coat_head_enhanced, new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 45), ModItems.armor_of_swiftness_chest_ultimate, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 45), ModItems.armor_of_swiftness_legs_ultimate, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(15, 30), ModItems.armor_of_swiftness_feet_ultimate, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.armor_of_swiftness_head_ultimate, new Trades.Price(1, 1), 6, 1)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(20, 32), (ItemLike)Items.f_42415_, new Trades.Price(1, 2)), new Trades.ItemsForSouls(new Trades.Price(15, 25), ModItems.holy_water_bottle_ultimate, new Trades.Price(1, 2)), new Trades.ItemsForSouls(new Trades.Price(30, 40), ModItems.obsidian_armor_chest_enhanced, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), ModItems.obsidian_armor_legs_enhanced, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), ModItems.obsidian_armor_feet_enhanced, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), ModItems.obsidian_armor_head_enhanced, new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 55), ModItems.hunter_coat_chest_ultimate, new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 55), ModItems.hunter_coat_legs_ultimate, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(20, 35), ModItems.hunter_coat_feet_ultimate, new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 35), ModItems.hunter_coat_head_ultimate, new Trades.Price(1, 1), 6, 1)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(30, 64), ModItems.obsidian_armor_chest_ultimate, new Trades.Price(1, 1), 10, 1), new Trades.ItemsForSouls(new Trades.Price(25, 64), ModItems.obsidian_armor_legs_ultimate, new Trades.Price(1, 1), 9, 1), new Trades.ItemsForSouls(new Trades.Price(20, 40), ModItems.obsidian_armor_feet_ultimate, new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(20, 40), ModItems.obsidian_armor_head_ultimate, new Trades.Price(1, 1), 8, 1)});
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> getVampireTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(10, 15), (ItemLike)ModItems.pure_blood_0, new Trades.Price(1, 1)), new Trades.BloodBottleForHeart(new Trades.Price(3, 12), new Trades.Price(1, 15), 9), new VillagerTrades.EmeraldForItems((ItemLike)ModBlocks.vampire_orchid, 4, 1, 3), new Trades.BiomeMapForEmeralds(5, ModBiomes.VAMPIRE_FOREST, 3, 2)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(25, 30), (ItemLike)ModItems.pure_blood_1, new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(1, 5), (ItemLike)ModBlocks.coffin, new Trades.Price(1, 1), 2, 2), new Trades.ItemsForHeart(new Trades.Price(10, 25), (ItemLike)ModItems.blood_infused_iron_ingot, new Trades.Price(1, 3))}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(30, 40), (ItemLike)ModItems.pure_blood_2, new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(15, 30), (ItemLike)ModItems.blood_infused_enhanced_iron_ingot, new Trades.Price(1, 2))}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(20, 30), (ItemLike)ModItems.pure_blood_3, new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(10, 30), new ItemStack[]{new ItemStack((ItemLike)ModItems.vampire_cloak_black_blue), new ItemStack((ItemLike)ModItems.vampire_cloak_black_red), new ItemStack((ItemLike)ModItems.vampire_cloak_black_white), new ItemStack((ItemLike)ModItems.vampire_cloak_red_black), new ItemStack((ItemLike)ModItems.vampire_cloak_white_black)}, new Trades.Price(1, 1), 10, 2)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(30, 40), (ItemLike)ModItems.pure_blood_4, new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(10, 30), new ItemStack[]{new ItemStack((ItemLike)ModItems.vampire_cloak_black_blue), new ItemStack((ItemLike)ModItems.vampire_cloak_black_red), new ItemStack((ItemLike)ModItems.vampire_cloak_black_white), new ItemStack((ItemLike)ModItems.vampire_cloak_red_black), new ItemStack((ItemLike)ModItems.vampire_cloak_white_black)}, new Trades.Price(1, 1), 10, 2), new VillagerTrades.ItemsForEmeralds((Item)ModItems.heart_seeker_ultimate, 40, 1, 15), new VillagerTrades.ItemsForEmeralds((Item)ModItems.heart_striker_ultimate, 40, 1, 15)});
    }
}

