/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.inventory.recipes.ConfigCondition;
import de.teamlapen.vampirism.inventory.recipes.ShapedItemWithTierRepair;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class ModRecipes {
    public static final RecipeType<IWeaponTableRecipe> WEAPONTABLE_CRAFTING_TYPE = RecipeType.m_44119_((String)new ResourceLocation("vampirism", "weapontable_crafting").toString());
    public static final RecipeType<AlchemicalCauldronRecipe> ALCHEMICAL_CAULDRON_TYPE = RecipeType.m_44119_((String)new ResourceLocation("vampirism", "alchemical_cauldron").toString());
    @ObjectHolder(value="vampirism:shaped_crafting_weapontable")
    public static final RecipeSerializer<ShapedWeaponTableRecipe> shaped_crafting_weapontable = (RecipeSerializer)UtilLib.getNull();
    @ObjectHolder(value="vampirism:shapeless_crafting_weapontable")
    public static final RecipeSerializer<ShapelessWeaponTableRecipe> shapeless_crafting_weapontable = (RecipeSerializer)UtilLib.getNull();
    @ObjectHolder(value="vampirism:repair_iitemwithtier")
    public static final RecipeSerializer<ShapedRecipe> repair_iitemwithtier = (RecipeSerializer)UtilLib.getNull();
    @ObjectHolder(value="vampirism:alchemical_cauldron")
    public static final RecipeSerializer<AlchemicalCauldronRecipe> alchemical_cauldron = (RecipeSerializer)UtilLib.getNull();
    public static final IConditionSerializer<?> CONFIG_CONDITION = CraftingHelper.register((IConditionSerializer)new ConfigCondition.Serializer());
    private static final Map<Item, Integer> liquidColors = Maps.newHashMap();
    private static final Map<TagKey<Item>, Integer> liquidColorsTags = Maps.newHashMap();

    static void registerDefaultLiquidColors() {
        ModRecipes.registerLiquidColor(ModItems.holy_water_bottle_normal, 0x6666FF);
        ModRecipes.registerLiquidColor(ModItems.holy_water_bottle_enhanced, 0x6666FF);
        ModRecipes.registerLiquidColor(ModItems.holy_water_bottle_ultimate, 0x6666FF);
        ModRecipes.registerLiquidColor(ModTags.Items.GARLIC, 0xBBBBBB);
    }

    static void registerSerializer(IForgeRegistry<RecipeSerializer<?>> registry) {
        registry.register((IForgeRegistryEntry)((RecipeSerializer)new ShapedWeaponTableRecipe.Serializer().setRegistryName("vampirism", "shaped_crafting_weapontable")));
        registry.register((IForgeRegistryEntry)((RecipeSerializer)new ShapelessWeaponTableRecipe.Serializer().setRegistryName("vampirism", "shapeless_crafting_weapontable")));
        registry.register((IForgeRegistryEntry)((RecipeSerializer)new ShapedItemWithTierRepair.Serializer().setRegistryName("vampirism", "repair_iitemwithtier")));
        registry.register((IForgeRegistryEntry)((RecipeSerializer)new AlchemicalCauldronRecipe.Serializer().setRegistryName("vampirism", "alchemical_cauldron")));
    }

    public static void registerLiquidColor(Item item, int color) {
        liquidColors.put(item, color);
    }

    public static void registerLiquidColor(TagKey<Item> items, int color) {
        liquidColorsTags.put(items, color);
    }

    public static int getLiquidColor(Item stack) {
        Integer c = liquidColors.get(stack);
        if (c != null) {
            return c;
        }
        for (Map.Entry<TagKey<Item>, Integer> entry : liquidColorsTags.entrySet()) {
            if (!stack.m_204114_().m_203656_(entry.getKey())) continue;
            return entry.getValue();
        }
        return 0x505050;
    }
}

