/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.Codec;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="vampirism")
public class ModParticles {
    public static final ParticleType<FlyingBloodParticleData> flying_blood = (ParticleType)UtilLib.getNull();
    public static final ParticleType<FlyingBloodEntityParticleData> flying_blood_entity = (ParticleType)UtilLib.getNull();
    public static final ParticleType<GenericParticleData> generic = (ParticleType)UtilLib.getNull();

    static void registerParticles(IForgeRegistry<ParticleType<?>> registry) {
        registry.register((IForgeRegistryEntry)((ParticleType)new ParticleType<FlyingBloodParticleData>(false, FlyingBloodParticleData.DESERIALIZER){

            @Nonnull
            public Codec<FlyingBloodParticleData> m_7652_() {
                return FlyingBloodParticleData.CODEC;
            }
        }.setRegistryName(new ResourceLocation("vampirism", "flying_blood"))));
        registry.register((IForgeRegistryEntry)((ParticleType)new ParticleType<FlyingBloodEntityParticleData>(false, FlyingBloodEntityParticleData.DESERIALIZER){

            @Nonnull
            public Codec<FlyingBloodEntityParticleData> m_7652_() {
                return FlyingBloodEntityParticleData.CODEC;
            }
        }.setRegistryName(new ResourceLocation("vampirism", "flying_blood_entity"))));
        registry.register((IForgeRegistryEntry)((ParticleType)new ParticleType<GenericParticleData>(false, GenericParticleData.DESERIALIZER){

            @Nonnull
            public Codec<GenericParticleData> m_7652_() {
                return GenericParticleData.CODEC;
            }
        }.setRegistryName(new ResourceLocation("vampirism", "generic"))));
    }

    public static void spawnParticlesClient(Level worldIn, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int count, double maxDist, Random rand) {
        assert (!(worldIn instanceof ServerLevel)) : "Calling spawnParticlesClient on ServerWorld is pointless";
        for (int i = 0; i < count; ++i) {
            worldIn.m_7106_(particle, x + maxDist * (2.0 * rand.nextDouble() - 1.0), y + (2.0 * rand.nextDouble() - 1.0) * maxDist, z + (2.0 * rand.nextDouble() - 1.0) * maxDist, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticlesClient(Level worldIn, ParticleOptions particle, double x, double y, double z, int count, double maxDist, Random rand) {
        ModParticles.spawnParticlesClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0, count, maxDist, rand);
    }

    public static void spawnParticleClient(Level worldIn, ParticleOptions particle, double x, double y, double z) {
        ModParticles.spawnParticleClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnParticleClient(Level worldIn, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        assert (!(worldIn instanceof ServerLevel)) : "Calling spawnParticleClient on ServerWorld is pointless";
        worldIn.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static int spawnParticlesServer(Level worldIn, ParticleOptions particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        assert (worldIn instanceof ServerLevel) : "Calling spawnParticlesServer on client side is pointless";
        if (worldIn instanceof ServerLevel) {
            return ((ServerLevel)worldIn).m_8767_(particle, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        }
        return 0;
    }
}

