/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceBuilder;
import de.teamlapen.vampirism.config.BalanceConfig;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class VampirismConfig {
    public static final Client CLIENT;
    public static final Server SERVER;
    public static final Common COMMON;
    public static final BalanceConfig BALANCE;
    private static final ForgeConfigSpec clientSpec;
    private static final ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec commonSpec;
    private static BalanceBuilder balanceBuilder;

    public static void init() {
    }

    public static <T extends BalanceBuilder.Conf> void addBalanceModification(String key, Consumer<T> modifier) {
        if (balanceBuilder == null) {
            throw new IllegalStateException("Must add balance modifications during mod construction");
        }
        balanceBuilder.addBalanceModifier(key, modifier);
    }

    public static void finalizeAndRegisterConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            builder.comment("A ton of options which allow you to balance the mod to your desire");
            builder.push("balance");
            balanceBuilder.build(BALANCE, (ForgeConfigSpec.Builder)builder);
            builder.pop();
            return BALANCE;
        });
        ForgeConfigSpec balanceSpec = (ForgeConfigSpec)specPair.getRight();
        if (VampirismMod.inDev) {
            balanceBuilder.checkFields(BALANCE);
        }
        balanceBuilder = null;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)balanceSpec, "vampirism-balance.toml");
        FMLJavaModLoadingContext.get().getModEventBus().register(VampirismConfig.class);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).reloadConfiguration();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).reloadConfiguration();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        balanceBuilder = new BalanceBuilder();
        BALANCE = new BalanceConfig(balanceBuilder);
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue overrideGuiSkillButtonX;
        public final ForgeConfigSpec.IntValue overrideGuiSkillButtonY;
        public final ForgeConfigSpec.IntValue guiLevelOffsetX;
        public final ForgeConfigSpec.IntValue guiLevelOffsetY;
        public final ForgeConfigSpec.BooleanValue guiSkillButton;
        public final ForgeConfigSpec.BooleanValue renderAdvancedMobPlayerFaces;
        public final ForgeConfigSpec.BooleanValue renderVampireEyes;
        public final ForgeConfigSpec.BooleanValue renderVampireForestFog;
        public final ForgeConfigSpec.BooleanValue renderScreenOverlay;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> actionOrder;
        public final ForgeConfigSpec.BooleanValue disableFovChange;
        public final ForgeConfigSpec.BooleanValue disableBloodVisionRendering;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("client");
            builder.comment("Configure rendering").push("render");
            this.renderAdvancedMobPlayerFaces = builder.comment("Render player faces on advanced hunter or vampires").define("advancedMobPlayerFaces", true);
            this.renderVampireEyes = builder.comment("Render vampire eye/fang face overlay").define("vampireEyes", true);
            this.renderVampireForestFog = builder.comment("Render fog in vampire biome. Might be enforced server side").define("vampireForestFog", true);
            this.renderScreenOverlay = builder.comment("Render screen overlay. Don't disable").define("screenOverlay", true);
            builder.pop();
            builder.comment("Configure GUI").push("gui");
            this.guiLevelOffsetX = builder.comment("X-Offset of the level indicator from the center in pixels").defineInRange("levelOffsetX", 0, -250, 250);
            this.guiLevelOffsetY = builder.comment("Y-Offset of the level indicator from the bottom in pixels").defineInRange("levelOffsetY", 47, 0, 270);
            this.guiSkillButton = builder.comment("Render skill menu button in inventory").define("skillButtonEnable", true);
            this.overrideGuiSkillButtonX = builder.comment("Force the guiSkillButton to the following x position from the center of the inventory, default value is 125").defineInRange("overrideGuiSkillButtonX", 125, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.overrideGuiSkillButtonY = builder.comment("Force the guiSkillButton to the following y position from the center of the inventory, default value is -22").defineInRange("overrideGuiSkillButtonY", -22, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.actionOrder = builder.comment("Action Order in Select Action Screen (reset with \"\"), unnamed actions will appended").defineList("actionOrder", Collections.emptyList(), string -> string instanceof String && UtilLib.isValidResourceLocation((String)string));
            this.disableFovChange = builder.comment("Disable the FOV change caused by the speed buf for vampire players").define("disableFovChange", false);
            this.disableBloodVisionRendering = builder.comment("Disable the effect of blood vision. It can still be unlocked and activated but does not have any effect").define("disableBloodVisionRendering", false);
            builder.pop();
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue enforceRenderForestFog;
        public final ForgeConfigSpec.BooleanValue batModeInEnd;
        public final ForgeConfigSpec.BooleanValue unlockAllSkills;
        public final ForgeConfigSpec.BooleanValue pvpOnlyBetweenFactions;
        public final ForgeConfigSpec.BooleanValue pvpOnlyBetweenFactionsIncludeHumans;
        public final ForgeConfigSpec.IntValue sunscreenBeaconDistance;
        public final ForgeConfigSpec.BooleanValue sunscreenBeaconMineable;
        public final ForgeConfigSpec.BooleanValue autoCalculateEntityBlood;
        public final ForgeConfigSpec.BooleanValue playerCanTurnPlayer;
        public final ForgeConfigSpec.BooleanValue factionColorInChat;
        public final ForgeConfigSpec.BooleanValue lordPrefixInChat;
        public final ForgeConfigSpec.EnumValue<IMobOptions> entityIMob;
        public final ForgeConfigSpec.BooleanValue infectCreaturesSanguinare;
        public final ForgeConfigSpec.BooleanValue preventRenderingDebugBoundingBoxes;
        public final ForgeConfigSpec.BooleanValue sundamageUnknownDimension;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sundamageDimensionsOverridePositive;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sundamageDimensionsOverrideNegative;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sundamageDisabledBiomes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedBloodEntity;
        public final ForgeConfigSpec.BooleanValue disableFangInfection;
        public final ForgeConfigSpec.BooleanValue disableMobBiteInfection;
        public final ForgeConfigSpec.BooleanValue disableVillageGuards;
        public final ForgeConfigSpec.BooleanValue oldVampireBiomeGen;
        public final ForgeConfigSpec.BooleanValue infoAboutGuideAPI;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.enforceRenderForestFog = builder.comment("Prevent clients from disabling the vampire forest fog").define("enforceForestFog", true);
            this.batModeInEnd = builder.comment("If vampires can convert to a bat in the End").define("batModeInEnd", false);
            this.pvpOnlyBetweenFactions = builder.comment("If PVP should only be allowed between factions. PVP has to be enabled in the server properties for this. Not guaranteed to always protect player from teammates").define("pvpOnlyBetweenFactions", false);
            this.pvpOnlyBetweenFactionsIncludeHumans = builder.comment("If pvpOnlyBetweenFactions is enabled, this decides whether human players can be attacked and attack others").define("pvpOnlyBetweenFactionsIncludeHumans", false);
            this.sunscreenBeaconDistance = builder.comment("Block radius the sunscreen beacon affects").defineInRange("sunscreenBeaconDistance", 32, 1, 40000);
            this.sunscreenBeaconMineable = builder.comment("Whether the suncreen beacon can be mined in survival").define("sunscreenBeaconMineable", false);
            this.autoCalculateEntityBlood = builder.comment("Calculate the blood level for unknown creatures based on their size").define("autoCalculateEntityBlood", true);
            this.playerCanTurnPlayer = builder.comment("Whether players can infect other players").define("playersCanTurnPlayers", true);
            this.factionColorInChat = builder.comment("Whether to color player names in chat based on their current faction").define("factionColorInChat", true);
            this.lordPrefixInChat = builder.comment("Whether to add a prefix title based on the current lord level to the player names").define("lordPrefixInChat", true);
            this.entityIMob = builder.comment("Changes if entities are recognized as hostile by other mods. See https://github.com/TeamLapen/Vampirism/issues/199. Smart falls back to Never on servers ").defineEnum("entitiesIMob", (Enum)IMobOptions.SMART);
            this.infectCreaturesSanguinare = builder.comment("If enabled, creatures are infected with Sanguinare Vampirism first instead of immediately being converted to a vampire when their blood is sucked dry").define("infectCreaturesSanguinare", false);
            this.preventRenderingDebugBoundingBoxes = builder.comment("Prevent players from enabling the rendering of debug bounding boxes. This can allow them to see certain entities they are not supposed to see (e.g. disguised hunter").define("preventDebugBoundingBoxes", false);
            builder.push("sundamage");
            this.sundamageUnknownDimension = builder.comment("Whether vampires should receive sundamage in unknown dimensions").define("sundamageUnknownDimension", false);
            this.sundamageDimensionsOverridePositive = builder.comment("Add the string id in quotes of any dimension (/vampirism currentDimension) you want to enforce sundamage for to this comma-separated list. Overrides defaults and values added by other mods").defineList("sundamageDimensionsOverridePositive", Collections.emptyList(), string -> string instanceof String && UtilLib.isValidResourceLocation((String)string));
            this.sundamageDimensionsOverrideNegative = builder.comment("Add the string id in quotes of any dimension (/vampirism currentDimension) you want to disable sundamage for to this comma-separated list. Overrides defaults and values added by other mods").defineList("sundamageDimensionsOverrideNegative", Collections.emptyList(), string -> string instanceof String && UtilLib.isValidResourceLocation((String)string));
            this.sundamageDisabledBiomes = builder.comment("Additional biomes the player should not get sundamage in. Use biome ids e.g. [\"minecraft:mesa\", \"minecraft:plains\"]").defineList("sundamageDisabledBiomes", Collections.emptyList(), string -> string instanceof String && UtilLib.isValidResourceLocation((String)string));
            builder.pop();
            builder.push("entities");
            this.blacklistedBloodEntity = builder.comment("Blacklist entities from predefined or auto calculated blood values").defineList("blacklistedBloodEntity", Collections.emptyList(), string -> string instanceof String && UtilLib.isValidResourceLocation((String)string));
            builder.pop();
            builder.push("cheats");
            this.unlockAllSkills = builder.comment("CHEAT: If enabled, you will be able to unlock all skills at max level").define("allSkillsAtMaxLevel", false);
            builder.pop();
            builder.comment("Disabling these things might reduce fun or interfere with gameplay");
            builder.push("disable");
            this.disableFangInfection = builder.comment("Disable vampire fangs being usable to infect yourself").define("disableFangInfection", false);
            this.disableMobBiteInfection = builder.comment("Prevent vampire mobs from infecting players when attacking").define("disableMobBiteInfection", false);
            this.disableVillageGuards = builder.comment("Prevent villagers in hunter controlled villages to turn into guard villager when the village is attacked").define("disableVillageGuards", false);
            builder.pop();
            builder.push("internal");
            this.infoAboutGuideAPI = builder.comment("Send message about Guide-API once").define("infoAboutGuideAPI", true);
            this.oldVampireBiomeGen = builder.comment("If world was generated using the old vampirism biome").define("oldVampireBiomeGen", true);
            builder.pop();
            builder.pop();
        }

        public static enum IMobOptions {
            ALWAYS_IMOB,
            NEVER_IMOB,
            SMART;

        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue versionCheck;
        public final ForgeConfigSpec.BooleanValue collectStats;
        public final ForgeConfigSpec.ConfigValue<String> integrationsNotifier;
        public final ForgeConfigSpec.BooleanValue optifineBloodvisionWarning;
        public final ForgeConfigSpec.BooleanValue autoConvertGlassBottles;
        public final ForgeConfigSpec.BooleanValue umbrella;
        public final ForgeConfigSpec.IntValue vampireSpawnChance;
        public final ForgeConfigSpec.IntValue advancedVampireSpawnChance;
        public final ForgeConfigSpec.IntValue hunterSpawnChance;
        public final ForgeConfigSpec.IntValue advancedHunterSpawnChance;
        public final ForgeConfigSpec.IntValue baronSpawnChance;
        public final ForgeConfigSpec.BooleanValue addVampireForestToOverworld;
        public final ForgeConfigSpec.IntValue vampireForestWeight_terrablender;
        public final ForgeConfigSpec.BooleanValue enableHunterTentGeneration;
        public final ForgeConfigSpec.BooleanValue useVanillaCampfire;
        public final ForgeConfigSpec.IntValue villageTotemWeight;
        public final ForgeConfigSpec.BooleanValue villageReplaceTemples;
        public final ForgeConfigSpec.DoubleValue villageTotemFactionChance;
        public final ForgeConfigSpec.IntValue villageHunterTrainerWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings. Most other configuration can be found in the world (server)configuration folder").push("common");
            this.versionCheck = builder.comment("Check for new versions of Vampirism on startup").define("versionCheck", true);
            this.collectStats = builder.comment("Send mod version, MC version and mod count to mod author").define("collectStats", true);
            builder.push("internal");
            this.integrationsNotifier = builder.comment("INTERNAL - Set to 'never' if you don't want to be notified about integration mods").define("integrationsNotifier", (Object)"");
            this.optifineBloodvisionWarning = builder.comment("INTERNAL").define("optifineBloodvisionWarning", false);
            builder.pop();
            builder.pop();
            builder.comment("Affects all worlds. This is only considered on server (or in singleplayer), but Forge requires us to put it here").push("common-server");
            this.autoConvertGlassBottles = builder.comment("Whether glass bottles should be automatically be converted to blood bottles when needed").define("autoConvertGlassBottles", true);
            this.umbrella = builder.comment("If enabled adds a craftable umbrella that can be used to slowly walk though sunlight without taking damage").define("umbrella", false);
            builder.push("mobspawn");
            this.vampireSpawnChance = builder.comment("Vampire spawn chance/weight (e.g. Zombie: 100). Does not affect vampire forest.").defineInRange("vampireSpawnChance", 80, 0, 100000);
            this.advancedVampireSpawnChance = builder.comment("Advanced vampire spawn chance/weight (e.g. Zombie: 100). Does not affect vampire forest.").defineInRange("advancedVampireSpawnChance", 26, 0, 100000);
            this.hunterSpawnChance = builder.comment("Hunter spawn chance. By default they only spawn in tent camps, but you can enable global spawn here.").defineInRange("hunterSpawnChance", 0, 0, 10000);
            this.advancedHunterSpawnChance = builder.comment("Advanced hunter spawn chance. By default they only spawn in large tent camps, but you can enable global spawn here.").defineInRange("advancedHunterSpawnChance", 0, 0, 100000);
            this.baronSpawnChance = builder.comment("Vampire baron spawn chance in vampire forest (reference vampire in forest: 35)").defineInRange("baronSpawnChance", 10, 0, 10000);
            builder.pop();
            builder.comment("Settings here require a game restart").push("world");
            this.addVampireForestToOverworld = builder.comment("Whether to inject the vampire forest into the default overworld generation and to replace some Taiga areas").define("addVampireForestToOverworld", true);
            this.vampireForestWeight_terrablender = builder.comment("Only considered if terrablender installed. Heigher values increase Vampirism region weight (likelyhood to appear)").defineInRange("vampireForestWeight_terrablender", 2, 1, 1000);
            this.enableHunterTentGeneration = builder.comment("Control hunter camp generation. If disabled you should set hunterSpawnChance to 75.").define("enableHunterTentGeneration", true);
            this.useVanillaCampfire = builder.comment("Use the vanilla campfire block instead of Vampirism's much cooler one").define("useVanillaCampfire", false);
            builder.push("village");
            this.villageTotemWeight = builder.comment("Weight of the Totem Building inside the Village").defineInRange("totemWeight", 20, 0, 140);
            this.villageTotemFactionChance = builder.comment("Chance for a totem to have a faction after generation").defineInRange("villageTotemFactionChance", 0.6, 0.0, 1.0);
            this.villageHunterTrainerWeight = builder.comment("Weight of the Hunter Trainer Building inside the Village").defineInRange("villageHunterTrainerWeight", 50, 0, 140);
            this.villageReplaceTemples = builder.comment("Whether village Temples should be replaced with versions that contain church altars.").define("villageReplaceTemples", true);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }
}

