/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.command.arguments.RefinementSetArgument;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.items.RefinementItem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GiveAccessoriesCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"giveAccessories").requires(context -> context.m_6761_(2))).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).then(Commands.m_82129_((String)"set", (ArgumentType)RefinementSetArgument.actions()).executes(context -> GiveAccessoriesCommand.give((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), RefinementSetArgument.getSet((CommandContext<CommandSourceStack>)context, "set")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"random").executes(context -> GiveAccessoriesCommand.random((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_(), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> GiveAccessoriesCommand.random((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"help").executes(GiveAccessoriesCommand::help));
    }

    private static <Z extends Item> int give(CommandContext<CommandSourceStack> context, ServerPlayer asPlayer, int number, IRefinementSet set) {
        IFaction<?> faction = set.getFaction();
        if (faction instanceof PlayableFaction) {
            ItemStack s;
            Object i = ((PlayableFaction)faction).getRefinementItem(IRefinementItem.AccessorySlotType.values()[number - 1]);
            if (((IRefinementItem)i).applyRefinementSet(s = new ItemStack(i), set)) {
                asPlayer.m_36356_(s);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.vampirism.test.give_accessories.success", new Object[]{set.getName(), number}), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.vampirism.test.give_accessories.incompatible", new Object[]{set.getName(), number}), false);
            }
        }
        return 0;
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.vampirism.test.give_accessories.help"), false);
        return 0;
    }

    private static <T extends IFactionPlayer<T>> int random(CommandContext<CommandSourceStack> context, ServerPlayer entity, int amount) {
        IFaction<?> faction = VampirismAPI.factionRegistry().getFaction((Entity)entity);
        if (faction instanceof PlayableFaction) {
            for (int i = 0; i < amount; ++i) {
                ItemStack stack = RefinementItem.getRandomRefinementItem((PlayableFaction)faction);
                if (stack.m_41619_()) {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.vampirism.test.give_accessories.no_item"), false);
                    return 0;
                }
                entity.m_36356_(stack);
            }
        }
        return 0;
    }
}

