/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class RefinementSetArgument
implements ArgumentType<IRefinementSet> {
    public static final DynamicCommandExceptionType REFINEMENT_NOT_FOUND = new DynamicCommandExceptionType(particle -> new TranslatableComponent("command.vampirism.argument.refinement_set.notfound", new Object[]{particle}));
    private static final Collection<String> EXAMPLES = Arrays.asList("refinement_set", "modid:refinement_set");

    public static RefinementSetArgument actions() {
        return new RefinementSetArgument();
    }

    public static IRefinementSet getSet(CommandContext<CommandSourceStack> context, String name) {
        return (IRefinementSet)context.getArgument(name, IRefinementSet.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_((Iterable)ModRegistries.REFINEMENT_SETS.getKeys(), (SuggestionsBuilder)builder);
    }

    public IRefinementSet parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
        IRefinementSet set = (IRefinementSet)ModRegistries.REFINEMENT_SETS.getValue(id);
        if (set == null) {
            throw REFINEMENT_NOT_FOUND.create((Object)id);
        }
        return set;
    }
}

