/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LordCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_FACTION = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.lord.no_faction"));
    private static final SimpleCommandExceptionType LEVEL_UP_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.lord.level_failed"));
    private static final SimpleCommandExceptionType LORD_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.lord.failed"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"lord-level").requires(context -> context.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LordCommand.setLevel((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).m_81375_()})))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91460_()).executes(context -> LordCommand.setLevel((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), EntityArgument.m_91477_((CommandContext)context, (String)"player")))));
    }

    private static int setLevel(CommandContext<CommandSourceStack> context, int level, Collection<ServerPlayer> players) throws CommandSyntaxException {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            IPlayableFaction<?> faction = handler.getCurrentFaction();
            if (faction == null) {
                throw NO_FACTION.create();
            }
            int maxLevel = faction.getHighestReachableLevel();
            if (handler.getCurrentLevel() < maxLevel && !handler.setFactionLevel(faction, maxLevel)) {
                throw LEVEL_UP_FAILED.create();
            }
            if (handler.setLordLevel(level = Math.min(level, faction.getHighestLordLevel()))) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("command.vampirism.base.lord.successful", new Object[]{player.m_7755_(), faction.getName(), level}), true);
                continue;
            }
            throw LORD_FAILED.create();
        }
        return 0;
    }
}

