/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.command.arguments.BiomeArgument;
import de.teamlapen.vampirism.command.arguments.ModSuggestionProvider;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ConfigCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_SELECTED_ENTITY = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.config.bloodvalues.blacklist.no_entity"));
    private static final SimpleCommandExceptionType NO_CONFIG_TYPE = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.config.no_config"));
    private static final SimpleCommandExceptionType NO_BLOOD_VALUE_TYPE = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.config.bloodvalues.no_type"));
    private static final SimpleCommandExceptionType NO_BLOOD_VALUE_BLACKLIST_TYPE = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.config.bloodvalues.blacklist.no_type"));
    private static final SimpleCommandExceptionType NO_SUN_DAMAGE_TYPE = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.config.sun_damage.no_type"));
    private static final SimpleCommandExceptionType NO_SUN_DAMAGE_BLACKLIST_TYPE = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.vampirism.base.config.sun_damage.blacklist.no_type"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(context -> context.m_6761_(3))).executes(context -> {
            throw NO_CONFIG_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"bloodvalues").executes(context -> {
            throw NO_BLOOD_VALUE_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"blacklist").executes(context -> {
            throw NO_BLOOD_VALUE_BLACKLIST_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"entity").executes(context -> ConfigCommand.blacklistEntity(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(ModSuggestionProvider.ENTITIES).executes(context -> ConfigCommand.blacklistEntity(((CommandSourceStack)context.getSource()).m_81375_(), EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sundamage").executes(context -> {
            throw NO_SUN_DAMAGE_TYPE.create();
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blacklist").executes(context -> {
            throw NO_SUN_DAMAGE_BLACKLIST_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"biome").executes(context -> ConfigCommand.blacklistBiome(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"biome", (ArgumentType)BiomeArgument.biome()).suggests(ModSuggestionProvider.BIOMES).executes(context -> ConfigCommand.blacklistBiome(((CommandSourceStack)context.getSource()).m_81375_(), BiomeArgument.getBiomeId((CommandContext<CommandSourceStack>)context, "biome")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").executes(context -> ConfigCommand.blacklistDimension(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> ConfigCommand.blacklistDimension(((CommandSourceStack)context.getSource()).m_81375_(), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension"))))))).then(Commands.m_82127_((String)"enforce").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").executes(context -> ConfigCommand.enforceDimension(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> ConfigCommand.enforceDimension(((CommandSourceStack)context.getSource()).m_81375_(), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension")))))));
    }

    private static int blacklistEntity(ServerPlayer player) throws CommandSyntaxException {
        AABB axisalignedbb;
        Vec3 vec3d = player.m_20299_(1.0f);
        double d0 = 50.0;
        Vec3 vec3d1 = player.m_20252_(1.0f);
        Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * d0, vec3d1.f_82480_ * d0, vec3d1.f_82481_ * d0);
        EntityHitResult result = ProjectileUtil.m_37304_((Level)player.f_19853_, (Entity)player, (Vec3)vec3d, (Vec3)vec3d2, (AABB)(axisalignedbb = player.m_142469_().m_82369_(vec3d1.m_82490_(d0)).m_82400_(1.0)), a -> !a.m_5833_());
        if (result == null) {
            throw NO_SELECTED_ENTITY.create();
        }
        Entity entity = result.m_82443_();
        EntityType entityType = entity.m_6095_();
        return ConfigCommand.blacklistEntity(player, entityType.getRegistryName());
    }

    private static int blacklistEntity(ServerPlayer player, ResourceLocation entity) {
        return ConfigCommand.modifyList(player, entity, VampirismConfig.SERVER.blacklistedBloodEntity, "command.vampirism.base.config.entity.blacklisted", "command.vampirism.base.config.entity.not_blacklisted");
    }

    private static int blacklistBiome(ServerPlayer player) {
        return ConfigCommand.blacklistBiome(player, (ResourceLocation)player.m_20193_().m_204166_(player.m_142538_()).m_203439_().map(ResourceKey::m_135782_, ForgeRegistryEntry::getRegistryName));
    }

    private static int blacklistBiome(ServerPlayer player, ResourceLocation biome) {
        return ConfigCommand.modifyList(player, biome, VampirismConfig.SERVER.sundamageDisabledBiomes, "command.vampirism.base.config.biome.blacklisted", "command.vampirism.base.config.biome.not_blacklisted");
    }

    private static int blacklistDimension(ServerPlayer player) {
        return ConfigCommand.blacklistDimension(player, player.m_183503_());
    }

    private static int blacklistDimension(ServerPlayer player, ServerLevel dimension) {
        return ConfigCommand.modifyList(player, dimension.m_46472_().m_135782_(), VampirismConfig.SERVER.sundamageDimensionsOverrideNegative, "command.vampirism.base.config.dimension.blacklisted", "command.vampirism.base.config.dimension.not_blacklisted");
    }

    private static int enforceDimension(ServerPlayer player) {
        return ConfigCommand.enforceDimension(player, player.m_183503_());
    }

    private static int enforceDimension(ServerPlayer player, ServerLevel dimension) {
        return ConfigCommand.modifyList(player, dimension.m_46472_().m_135782_(), VampirismConfig.SERVER.sundamageDimensionsOverridePositive, "command.vampirism.base.config.dimension.enforced", "command.vampirism.base.config.dimension.not_enforced");
    }

    private static int modifyList(ServerPlayer player, ResourceLocation id, ForgeConfigSpec.ConfigValue<List<? extends String>> configList, String blacklist, String not_blacklist) {
        List list = (List)configList.get();
        if (!list.contains(id.toString())) {
            list.add(id.toString());
            player.m_5661_((Component)new TranslatableComponent(blacklist, new Object[]{id}), false);
        } else {
            list.remove(id.toString());
            player.m_5661_((Component)new TranslatableComponent(not_blacklist, new Object[]{id}), false);
        }
        configList.set((Object)list);
        return 0;
    }
}

