/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.HunterEquipmentModel;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HunterEquipmentLayer<T extends Mob, Q extends EntityModel<T>>
extends RenderLayer<T, Q> {
    private final HunterEquipmentModel<T> equipmentModel;
    private final ResourceLocation textureExtra = new ResourceLocation("vampirism", "textures/entity/hunter_extra.png");
    private final Function<T, HunterEquipmentModel.StakeType> predicateStake;
    private final Function<T, HunterEquipmentModel.HatType> functionHat;

    public HunterEquipmentLayer(RenderLayerParent<T, Q> entityRendererIn, EntityModelSet modelSet, Function<T, HunterEquipmentModel.StakeType> predicateStake, Function<T, HunterEquipmentModel.HatType> functionHat) {
        super(entityRendererIn);
        this.equipmentModel = new HunterEquipmentModel(modelSet.m_171103_(ModEntitiesRender.HUNTER_EQUIPMENT));
        this.predicateStake = predicateStake;
        this.functionHat = functionHat;
    }

    public void render(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entityIn.m_20145_()) {
            this.equipmentModel.setHat(this.functionHat.apply(entityIn));
            this.equipmentModel.setWeapons(this.predicateStake.apply(entityIn));
            HunterEquipmentLayer.m_117359_((EntityModel)this.m_117386_(), this.equipmentModel, (ResourceLocation)this.textureExtra, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entityIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

