/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.render.entities.DualBipedRenderer;
import de.teamlapen.vampirism.client.render.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class VampireMinionRenderer
extends DualBipedRenderer<VampireMinionEntity, PlayerModel<VampireMinionEntity>> {
    private final Pair<ResourceLocation, Boolean>[] textures;
    private final Pair<ResourceLocation, Boolean>[] minionSpecificTextures;

    public VampireMinionRenderer(EntityRendererProvider.Context context) {
        super(context, new PlayerModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED), false), new PlayerModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_SLIM), true), 0.5f);
        ResourceManager rm = Minecraft.m_91087_().m_91098_();
        this.textures = this.gatherTextures("textures/entity/vampire", true);
        this.minionSpecificTextures = this.gatherTextures("textures/entity/minion/vampire", false);
        this.m_115326_(new PlayerBodyOverlayLayer(this));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_ARMOR_INNER)), new HumanoidModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_ARMOR_OUTER))));
        ((PlayerModel)this.m_7200_()).f_103378_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_102810_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_103375_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_102811_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_103374_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_102812_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_103376_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_102814_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_103377_.f_104207_ = false;
        ((PlayerModel)this.m_7200_()).f_102813_.f_104207_ = false;
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    public int getVampireTextureCount() {
        return this.textures.length;
    }

    @Override
    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(VampireMinionEntity entity) {
        Pair<ResourceLocation, Boolean> p;
        Pair<ResourceLocation, Boolean> pair = p = entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getVampireType() % this.minionSpecificTextures.length] : this.textures[entity.getVampireType() % this.textures.length];
        if (entity.shouldRenderLordSkin()) {
            return entity.getOverlayPlayerProperties().map(Pair::getRight).map(b -> Pair.of((Object)((ResourceLocation)p.getLeft()), (Object)b)).orElse(p);
        }
        return p;
    }

    protected void scale(VampireMinionEntity entityIn, PoseStack matrixStackIn, float partialTickTime) {
        float s = entityIn.m_6134_();
        matrixStackIn.m_85841_(s, s, s);
    }
}

