/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.MixinHooks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RenderHandler
implements ResourceManagerReloadListener {
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @Nonnull
    private final Minecraft mc;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int VAMPIRE_BIOME_FADE_TICKS = 60;
    private final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private OutlineBufferSource bloodVisionBuffer;
    private Bat entityBat;
    private int vampireBiomeTicks = 0;
    private boolean insideFog = false;
    private int bloodVisionTicks = 0;
    private int lastBloodVisionTicks = 0;
    private float vampireBiomeFogDistanceMultiplier = 1.0f;
    @Nullable
    private PostChain blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean reducedBloodVision = false;
    @Nullable
    private PostPass blur1;
    @Nullable
    private PostPass blur2;
    @Nullable
    private PostPass blit0;
    private boolean isInsideBloodVisionRendering = false;

    public RenderHandler(@Nonnull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (this.shouldRenderBloodVision()) {
            this.reducedBloodVision = OptifineHandler.isShaders();
            if (!this.reducedBloodVision) {
                if (this.displayHeight != this.mc.m_91268_().m_85442_() || this.displayWidth != this.mc.m_91268_().m_85441_()) {
                    this.displayHeight = this.mc.m_91268_().m_85442_();
                    this.displayWidth = this.mc.m_91268_().m_85441_();
                    this.updateFramebufferSize(this.displayWidth, this.displayHeight);
                }
                this.adjustBloodVisionShaders(this.getBloodVisionProgress((float)event.getPartialTicks()));
            } else {
                MixinHooks.enforcingGlowing_bloodVision = true;
            }
        }
        if (((Boolean)VampirismConfig.SERVER.preventRenderingDebugBoundingBoxes.get()).booleanValue()) {
            Minecraft.m_91087_().m_91290_().m_114473_(false);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.lastBloodVisionTicks = this.bloodVisionTicks;
        VampirePlayer vampire = VampirePlayer.getOpt((Player)this.mc.f_91074_).resolve().orElse(null);
        if (vampire != null) {
            if (vampire.getSpecialAttributes().blood_vision && !((Boolean)VampirismConfig.CLIENT.disableBloodVisionRendering.get()).booleanValue() && !vampire.isGettingSundamage((LevelAccessor)this.mc.f_91074_.f_19853_)) {
                if (this.bloodVisionTicks < 80) {
                    ++this.bloodVisionTicks;
                }
            } else {
                if (this.bloodVisionTicks > 0) {
                    this.bloodVisionTicks -= 2;
                }
                if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                    this.bloodVisionTicks = 0;
                }
            }
        }
        if (this.mc.f_91074_.f_19797_ % 10 == 0) {
            if ((((Boolean)VampirismConfig.CLIENT.renderVampireForestFog.get()).booleanValue() || ((Boolean)VampirismConfig.SERVER.enforceRenderForestFog.get()).booleanValue()) && (Helper.isEntityInArtificalVampireFogArea((Entity)this.mc.f_91074_) || Helper.isEntityInVampireBiome((Entity)this.mc.f_91074_))) {
                this.insideFog = true;
                this.vampireBiomeFogDistanceMultiplier = vampire != null && vampire.getLevel() > 0 ? 2.0f : 1.0f;
                this.vampireBiomeFogDistanceMultiplier = (float)((double)this.vampireBiomeFogDistanceMultiplier + (vampire != null && vampire.getSkillHandler().isRefinementEquipped(ModRefinements.vista) ? (Double)VampirismConfig.BALANCE.vrVistaMod.get() : 0.0));
            } else {
                this.insideFog = false;
            }
        }
        if (this.insideFog) {
            if (this.vampireBiomeTicks < 60) {
                ++this.vampireBiomeTicks;
            }
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (this.vampireBiomeTicks == 0) {
            return;
        }
        float f = 60.0f / (float)this.vampireBiomeTicks / 1.5f;
        float fogStart = Math.min(event.getFarPlaneDistance() * 0.75f, 6.0f * (f *= this.vampireBiomeFogDistanceMultiplier));
        float fogEnd = Math.min(event.getFarPlaneDistance(), 50.0f * f);
        RenderSystem.m_157445_((float)(event.getMode() == FogRenderer.FogMode.FOG_SKY ? 0.0f : fogStart));
        RenderSystem.m_157443_((float)fogEnd);
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (this.mc.f_91074_ != null && this.mc.f_91074_.m_6084_() && VampirismPlayerAttributes.get((Player)this.mc.f_91074_).getVampSpecial().bat) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        if (!this.isInsideBloodVisionRendering && this.shouldRenderBloodVision() && !this.reducedBloodVision) {
            LivingEntity entity = event.getEntity();
            boolean flag = !(entity instanceof Player) || VampirismPlayerAttributes.get((Player)((Player)entity)).getHuntSpecial().fullHunterCoat == null;
            double dist = this.mc.f_91074_.m_20280_((Entity)entity);
            if (dist > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistanceSq.get()).intValue()) {
                flag = false;
            }
            if (flag) {
                LazyOptional<IExtendedCreatureVampirism> opt;
                LazyOptional<IExtendedCreatureVampirism> lazyOptional = opt = entity instanceof PathfinderMob && entity.m_6084_() ? ExtendedCreature.getSafe((Entity)entity) : LazyOptional.empty();
                int color = opt.map(creature -> creature.getBlood() > 0 && !creature.hasPoisonousBlood()).orElse(false) != false ? 0xFF0000 : (VampirismPlayerAttributes.get((Player)this.mc.f_91074_).getVampSpecial().blood_vision_garlic && (opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) != false || entity instanceof IHunterMob) ? 524039 : 0xA0A0A0);
                EntityRenderDispatcher renderManager = this.mc.m_91290_();
                if (this.bloodVisionBuffer == null) {
                    this.bloodVisionBuffer = new OutlineBufferSource(this.mc.m_91269_().m_110104_());
                }
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getBloodVisionProgress(event.getPartialTick()));
                this.bloodVisionBuffer.m_109929_(r, g, b, alpha);
                float f = Mth.m_14179_((float)event.getPartialTick(), (float)entity.f_19859_, (float)entity.m_146908_());
                this.isInsideBloodVisionRendering = true;
                EntityRenderer entityrenderer = renderManager.m_114382_((Entity)entity);
                entityrenderer.m_7392_((Entity)entity, f, event.getPartialTick(), event.getPoseStack(), (MultiBufferSource)this.bloodVisionBuffer, renderManager.m_114394_((Entity)entity, event.getPartialTick()));
                this.mc.m_91385_().m_83947_(false);
                this.isInsideBloodVisionRendering = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && VampirismPlayerAttributes.get((Player)entity).getHuntSpecial().isDisguised()) {
            IItemWithTier.TIER hunterCoatTier;
            double dist;
            double d = dist = this.mc.f_91074_ == null ? 0.0 : entity.m_20280_((Entity)this.mc.f_91074_);
            if (dist > 64.0) {
                event.setCanceled(true);
            } else if (dist > 16.0 && ((hunterCoatTier = VampirismPlayerAttributes.get((Player)((Player)entity)).getHuntSpecial().fullHunterCoat) == IItemWithTier.TIER.ENHANCED || hunterCoatTier == IItemWithTier.TIER.ULTIMATE)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getPlayer();
        VampirePlayerSpecialAttributes vAtt = VampirismPlayerAttributes.get(player).getVampSpecial();
        if (vAtt.invisible) {
            event.setCanceled(true);
        } else if (vAtt.bat) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = (Bat)EntityType.f_20549_.m_20615_(event.getEntity().m_20193_());
                this.entityBat.m_27456_(false);
            }
            float partialTicks = event.getPartialTick();
            this.entityBat.f_20884_ = player.f_20884_;
            this.entityBat.f_20883_ = player.f_20883_;
            this.entityBat.f_19797_ = player.f_19797_;
            this.entityBat.m_146926_(player.m_146909_());
            this.entityBat.m_146922_(player.m_146908_());
            this.entityBat.f_20885_ = player.f_20885_;
            this.entityBat.f_19859_ = player.f_19859_;
            this.entityBat.f_19860_ = player.f_19860_;
            this.entityBat.f_20886_ = player.f_20886_;
            this.entityBat.m_6842_(player.m_20145_());
            double d0 = Mth.m_14139_((double)partialTicks, (double)this.entityBat.f_19790_, (double)this.entityBat.m_20185_());
            double d1 = Mth.m_14139_((double)partialTicks, (double)this.entityBat.f_19791_, (double)this.entityBat.m_20186_());
            double d2 = Mth.m_14139_((double)partialTicks, (double)this.entityBat.f_19792_, (double)this.entityBat.m_20189_());
            float f = Mth.m_14179_((float)partialTicks, (float)this.entityBat.f_19859_, (float)this.entityBat.m_146908_());
            this.mc.m_91290_().m_114384_((Entity)this.entityBat, d0, d1, d2, f, partialTicks, event.getPoseStack(), (MultiBufferSource)this.mc.m_91269_().m_110104_(), this.mc.m_91290_().m_114394_((Entity)this.entityBat, partialTicks));
        } else if (vAtt.isDBNO) {
            event.getPoseStack().m_85837_(1.2, 0.0, 0.0);
            PlayerModel m = (PlayerModel)event.getRenderer().m_7200_();
            m.f_102811_.f_104207_ = false;
            m.f_103375_.f_104207_ = false;
            m.f_102812_.f_104207_ = false;
            m.f_103374_.f_104207_ = false;
            m.f_102813_.f_104207_ = false;
            m.f_102814_.f_104207_ = false;
            m.f_103377_.f_104207_ = false;
            m.f_103376_.f_104207_ = false;
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelLastEvent event) {
        MixinHooks.enforcingGlowing_bloodVision = false;
        if (this.mc.f_91073_ == null) {
            return;
        }
        float partialTicks = this.mc.m_91296_();
        if (this.shouldRenderBloodVision() && !this.reducedBloodVision) {
            this.blurShader.m_110023_(partialTicks);
            if (this.bloodVisionBuffer != null) {
                this.bloodVisionBuffer.m_109928_();
            }
        }
    }

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        this.reMakeBloodVisionShader();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.bloodVisionTicks = 0;
    }

    public boolean shouldRenderBloodVision() {
        return this.bloodVisionTicks > 0 && this.blurShader != null && this.mc.f_91074_ != null;
    }

    private void adjustBloodVisionShaders(float progress) {
        if (this.blit0 == null || this.blur1 == null || this.blur2 == null) {
            return;
        }
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        this.blit0.m_110074_().m_108960_("ColorModulate").m_5805_(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
        this.blur1.m_110074_().m_108960_("Radius").m_5985_((float)Math.round(15.0f * progress));
        this.blur2.m_110074_().m_108960_("Radius").m_5985_((float)Math.round(15.0f * progress));
    }

    private float getBloodVisionProgress(float partialTicks) {
        return ((float)this.bloodVisionTicks + (float)(this.bloodVisionTicks - this.lastBloodVisionTicks) * partialTicks) / 80.0f;
    }

    private void reMakeBloodVisionShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = new ResourceLocation("vampirism", "shaders/blank.json");
        try {
            this.blurShader = new PostChain(this.mc.m_91097_(), this.mc.m_91098_(), this.mc.m_91385_(), resourcelocationBlur);
            RenderTarget swap = this.blurShader.m_110036_("swap");
            this.blit0 = this.blurShader.m_110042_("blit", swap, this.mc.m_91385_());
            this.blur1 = this.blurShader.m_110042_("blur", this.mc.m_91385_(), swap);
            this.blur1.m_110074_().m_108960_("BlurDir").m_7971_(1.0f, 0.0f);
            this.blur2 = this.blurShader.m_110042_("blur", swap, this.mc.m_91385_());
            this.blur2.m_110074_().m_108960_("BlurDir").m_7971_(0.0f, 1.0f);
            this.blurShader.m_110025_(this.mc.m_91268_().m_85441_(), this.mc.m_91268_().m_85442_());
        }
        catch (Exception e) {
            this.LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.m_110025_(width, height);
        }
    }
}

