/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.blockentity.BloodContainerBlockEntity;
import de.teamlapen.vampirism.core.ModFluids;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class BakedBloodContainerModel
implements IDynamicBakedModel {
    public static final int FLUID_LEVELS = 14;
    public static final BakedModel[] BLOOD_FLUID_MODELS = new BakedModel[14];
    public static final BakedModel[] IMPURE_BLOOD_FLUID_MODELS = new BakedModel[14];
    private static final ItemOverrides overrideList = new CustomItemOverride();
    private final BakedModel baseModel;
    private boolean impure;
    private int fluidLevel = 0;
    private boolean item;

    public BakedBloodContainerModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public BakedBloodContainerModel(BakedModel baseModel, FluidStack stack) {
        this.baseModel = baseModel;
        this.impure = stack.getFluid().equals(ModFluids.impure_blood);
        this.fluidLevel = Mth.m_14045_((int)(stack.getAmount() / 900), (int)1, (int)14) - 1;
        this.item = true;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return overrideList;
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.baseModel.m_6840_(state, side, rand));
        if (!this.item) {
            Integer level = (Integer)extraData.getData(BloodContainerBlockEntity.FLUID_LEVEL_PROP);
            Boolean impure = (Boolean)extraData.getData(BloodContainerBlockEntity.FLUID_IMPURE);
            if (impure != null && level != null && level > 0 && level <= 14) {
                quads.addAll((impure != false ? IMPURE_BLOOD_FLUID_MODELS[level - 1] : BLOOD_FLUID_MODELS[level - 1]).m_6840_(state, side, rand));
            }
        } else {
            quads.addAll((this.impure ? IMPURE_BLOOD_FLUID_MODELS[this.fluidLevel] : BLOOD_FLUID_MODELS[this.fluidLevel]).m_6840_(state, side, rand));
        }
        return quads;
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    private static class CustomItemOverride
    extends ItemOverrides {
        CustomItemOverride() {
        }

        public BakedModel m_173464_(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, ClientLevel world, LivingEntity entity, int p) {
            FluidStack fluid;
            if (originalModel instanceof BakedBloodContainerModel && stack.m_41782_() && stack.m_41783_().m_128441_("fluid") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_().m_128469_("fluid"))).isEmpty()) {
                return new BakedBloodContainerModel(originalModel, fluid);
            }
            return originalModel;
        }
    }
}

