/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class WingModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private static final String WING_RIGHT = "wing_right";
    private static final String WING_RIGHT2 = "wing_right2";
    private static final String WING_LEFT = "wing_left";
    private static final String WING_LEFT2 = "wing_left2";
    public ModelPart wingRight;
    public ModelPart wingLeft;
    public ModelPart wingRight2;
    public ModelPart wingLeft2;

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition wingr = part.m_171599_(WING_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 46).m_171481_(-18.0f, -6.0f, 0.0f, 18.0f, 18.0f, 0.0f), PartPose.m_171423_((float)0.2f, (float)2.5f, (float)2.0f, (float)0.13665928f, (float)0.5462881f, (float)0.27314404f));
        wingr.m_171599_(WING_RIGHT2, CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-16.0f, -4.0f, 0.0f, 16.0f, 18.0f, 0.0f), PartPose.m_171423_((float)-18.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.8196066f, (float)0.0f));
        PartDefinition wingl = part.m_171599_(WING_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 46).m_171480_().m_171481_(0.0f, -6.0f, 0.0f, 18.0f, 18.0f, 0.0f), PartPose.m_171423_((float)-0.2f, (float)-2.5f, (float)2.0f, (float)0.13665928f, (float)-0.63739425f, (float)-0.27314404f));
        wingl.m_171599_(WING_LEFT2, CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171481_(0.0f, -4.0f, 0.0f, 16.0f, 18.0f, 0.0f), PartPose.m_171423_((float)18.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.8196066f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public WingModel(ModelPart part) {
        this.wingRight = part.m_171324_(WING_RIGHT);
        this.wingRight2 = this.wingRight.m_171324_(WING_RIGHT2);
        this.wingLeft = part.m_171324_(WING_LEFT);
        this.wingLeft2 = this.wingLeft.m_171324_(WING_LEFT2);
    }

    public void copyRotationFromBody(ModelPart body) {
        this.wingLeft.f_104204_ = body.f_104204_;
        this.wingLeft2.f_104204_ = body.f_104204_;
        this.wingRight.f_104204_ = body.f_104204_;
        this.wingRight2.f_104204_ = body.f_104204_;
        this.wingLeft.f_104203_ = body.f_104203_;
        this.wingRight.f_104203_ = body.f_104203_;
        this.wingLeft.f_104205_ = body.f_104205_;
        this.wingRight.f_104205_ = body.f_104205_;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (entityIn.m_6144_()) {
            this.wingRight.f_104201_ = 3.0f;
            this.wingLeft.f_104201_ = 3.0f;
        } else {
            this.wingRight.f_104201_ = 2.5f;
            this.wingLeft.f_104201_ = 2.5f;
        }
        this.wingLeft.f_104205_ = (float)((double)this.wingLeft.f_104205_ - (double)Mth.m_14089_((float)(((float)((LivingEntity)entityIn).f_19797_ + partialTick) * 0.0662f + (float)Math.PI)) * 0.06);
        this.wingRight.f_104205_ = (float)((double)this.wingRight.f_104205_ + (double)Mth.m_14089_((float)(((float)((LivingEntity)entityIn).f_19797_ + partialTick) * 0.0662f + (float)Math.PI)) * 0.06);
        this.wingLeft.f_104204_ -= 0.3f;
        this.wingRight.f_104204_ += 0.3f;
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.f_104203_ = x;
        ModelRenderer.f_104204_ = y;
        ModelRenderer.f_104205_ = z;
    }

    public void setupAnim(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.wingLeft, (Object)this.wingRight);
    }

    protected HumanoidArm getSwingingSide(T entity) {
        HumanoidArm handside = entity.m_5737_();
        return ((LivingEntity)entity).f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return Collections.emptyList();
    }
}

