/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;

public class HunterEquipmentModel<T extends Mob>
extends HumanoidModel<T> {
    private static final String HAT_TOP = "hat_top";
    private static final String HAT_RIM = "hat_rim";
    private static final String AXE_SHAFT = "axe_shaft";
    private static final String AXE_BLADE1 = "axe_blade1";
    private static final String AXE_BLADE2 = "axe_blade2";
    private static final String STAKE_LEFT = "stake_left";
    private static final String STAKE_RIGHT = "stake_right";
    private static final String HAT_TOP2 = "hat_top2";
    private static final String HAT_RIM2 = "hat_rim2";
    private static final String HAT_RIM3 = "hat_rim3";
    private final ModelPart hatTop;
    private final ModelPart hatRim;
    private final ModelPart axeShaft;
    private final ModelPart axeBlade1;
    private final ModelPart axeBlade2;
    private final ModelPart stake;
    private final ModelPart stakeRight;
    private final ModelPart hatTop2;
    private final ModelPart hatRim2;
    private final ModelPart hatRim3;

    public static LayerDefinition createLayer() {
        float offset = 0.0f;
        PartPose headPose = PartPose.m_171419_((float)0.0f, (float)offset, (float)0.0f);
        PartPose rightArmPose = PartPose.m_171419_((float)-5.0f, (float)(2.0f + offset), (float)0.0f);
        PartPose leftArmPose = PartPose.m_171419_((float)5.0f, (float)(2.0f + offset), (float)0.0f);
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)offset);
        PartDefinition part = mesh.m_171576_();
        part.m_171599_(HAT_TOP2, CubeListBuilder.m_171558_().m_171514_(0, 31).m_171480_().m_171481_(-4.5f, -12.0f, -4.5f, 9.0f, 3.0f, 9.0f), headPose);
        part.m_171599_(HAT_RIM2, CubeListBuilder.m_171558_().m_171514_(0, 31).m_171480_().m_171481_(-8.0f, -9.0f, -8.0f, 16.0f, 1.0f, 16.0f), headPose);
        part.m_171599_(HAT_RIM3, CubeListBuilder.m_171558_().m_171514_(0, 37).m_171480_().m_171481_(-5.0f, -6.0f, -5.0f, 10.0f, 1.0f, 10.0f), headPose);
        part.m_171599_(HAT_TOP, CubeListBuilder.m_171558_().m_171514_(0, 31).m_171480_().m_171481_(-4.0f, -14.0f, -4.0f, 8.0f, 5.0f, 8.0f), headPose);
        part.m_171599_(HAT_RIM, CubeListBuilder.m_171558_().m_171514_(0, 35).m_171480_().m_171481_(-6.0f, -9.0f, -6.0f, 12.0f, 1.0f, 12.0f), headPose);
        part.m_171599_(AXE_SHAFT, CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171481_(-2.0f, 8.0f, -17.0f, 1.0f, 1.0f, 15.0f), rightArmPose);
        part.m_171599_(AXE_BLADE1, CubeListBuilder.m_171558_().m_171514_(0, 53).m_171480_().m_171481_(-2.0f, 4.0f, -16.0f, 1.0f, 4.0f, 7.0f), rightArmPose);
        part.m_171599_(AXE_BLADE2, CubeListBuilder.m_171558_().m_171514_(0, 53).m_171480_().m_171481_(-2.0f, 9.0f, -16.0f, 1.0f, 4.0f, 7.0f), rightArmPose);
        part.m_171599_(STAKE_LEFT, CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171481_(1.0f, 8.0f, -8.0f, 1.0f, 1.0f, 6.0f), leftArmPose);
        part.m_171599_(STAKE_RIGHT, CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171481_(-2.0f, 8.0f, -8.0f, 1.0f, 1.0f, 6.0f), rightArmPose);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public HunterEquipmentModel(ModelPart part) {
        super(part);
        this.hatTop = part.m_171324_(HAT_TOP);
        this.hatTop2 = part.m_171324_(HAT_TOP2);
        this.hatRim = part.m_171324_(HAT_RIM);
        this.hatRim2 = part.m_171324_(HAT_RIM2);
        this.hatRim3 = part.m_171324_(HAT_RIM3);
        this.axeShaft = part.m_171324_(AXE_SHAFT);
        this.axeBlade1 = part.m_171324_(AXE_BLADE1);
        this.axeBlade2 = part.m_171324_(AXE_BLADE2);
        this.stake = part.m_171324_(STAKE_LEFT);
        this.stakeRight = part.m_171324_(STAKE_RIGHT);
        super.m_8009_(false);
    }

    public void setHat(HatType hatType) {
        this.hatRim.f_104207_ = hatType == HatType.HAT1;
        this.hatTop.f_104207_ = this.hatRim.f_104207_;
        this.hatRim2.f_104207_ = hatType == HatType.HAT2;
        this.hatTop2.f_104207_ = this.hatRim2.f_104207_;
        this.hatRim3.f_104207_ = hatType == HatType.RIM_ONLY;
    }

    public void setWeapons(StakeType type) {
        boolean axe;
        this.stakeRight.f_104207_ = type == StakeType.ONLY;
        this.axeBlade2.f_104207_ = this.axeShaft.f_104207_ = (axe = type == StakeType.FULL || type == StakeType.AXE_ONLY);
        this.axeBlade1.f_104207_ = this.axeShaft.f_104207_;
        this.stake.f_104207_ = type == StakeType.FULL;
    }

    public void setupAnim(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.hatRim.m_104315_(this.f_102808_);
        this.hatTop.m_104315_(this.f_102808_);
        this.hatRim2.m_104315_(this.f_102808_);
        this.hatTop2.m_104315_(this.f_102808_);
        this.hatRim3.m_104315_(this.f_102808_);
        this.axeShaft.m_104315_(this.f_102811_);
        this.axeBlade1.m_104315_(this.f_102811_);
        this.axeBlade2.m_104315_(this.f_102811_);
        this.stake.m_104315_(this.f_102812_);
        this.stakeRight.m_104315_(this.f_102811_);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.axeBlade1, (Object)this.axeBlade2, (Object)this.axeShaft, (Object)this.stake, (Object)this.stakeRight));
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return Iterables.concat((Iterable)super.m_5607_(), (Iterable)ImmutableList.of((Object)this.hatRim, (Object)this.hatRim2, (Object)this.hatRim3, (Object)this.hatTop, (Object)this.hatTop2));
    }

    public static enum HatType {
        NONE,
        RIM_ONLY,
        HAT1,
        HAT2;


        public static HatType from(int id) {
            return switch (id) {
                case 0 -> HAT1;
                case 1 -> HAT2;
                case 2 -> RIM_ONLY;
                default -> NONE;
            };
        }
    }

    public static enum StakeType {
        NONE,
        ONLY,
        FULL,
        AXE_ONLY;

    }
}

