/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CoffinModel
extends Model {
    private static final String LEFT_PLATE = "left_plate";
    private static final String RIGHT_PLATE = "right_plate";
    private static final String BACK_PLATE = "back_plate";
    private static final String TOP_PLATE = "top_plate";
    private static final String BOTTOM_PLATE = "bottom_plate";
    private static final String LEFT_LID = "left_lid";
    private static final String RIGHT_LID = "right_lid";
    private static final String LEFT_HANDLE = "left_handle";
    private static final String RIGHT_HANDLE = "right_handle";
    private final ModelPart leftPlate;
    private final ModelPart rightPlate;
    private final ModelPart backPlate;
    private final ModelPart topPlate;
    private final ModelPart bottomPlate;
    private final ModelPart leftLid;
    private final ModelPart rightLid;
    private final ModelPart leftHandle;
    private final ModelPart rightHandle;
    private final List<ModelPart> modelParts;

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        part.m_171599_(LEFT_PLATE, CubeListBuilder.m_171558_().m_171514_(0, 64).m_171480_().m_171481_(7.0f, -12.0f, 0.0f, 1.0f, 12.0f, 32.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-8.0f));
        part.m_171599_(RIGHT_PLATE, CubeListBuilder.m_171558_().m_171514_(66, 64).m_171480_().m_171481_(-8.0f, -12.0f, 0.0f, 1.0f, 12.0f, 32.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-8.0f));
        part.m_171599_(BACK_PLATE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-8.0f, 0.0f, 0.0f, 16.0f, 1.0f, 32.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-8.0f));
        part.m_171599_(TOP_PLATE, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-7.0f, -12.0f, 31.0f, 14.0f, 12.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-8.0f));
        part.m_171599_(BOTTOM_PLATE, CubeListBuilder.m_171558_().m_171514_(0, 15).m_171480_().m_171481_(-7.0f, -11.0f, 0.0f, 14.0f, 12.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)-8.0f));
        part.m_171599_(LEFT_LID, CubeListBuilder.m_171558_().m_171514_(0, 33).m_171480_().m_171481_(0.0f, 0.0f, 0.0f, 7.0f, 1.0f, 30.0f), PartPose.m_171419_((float)-7.0f, (float)11.0f, (float)-7.0f));
        part.m_171599_(RIGHT_LID, CubeListBuilder.m_171558_().m_171514_(74, 33).m_171480_().m_171481_(-7.0f, 0.0f, 0.0f, 7.0f, 1.0f, 30.0f), PartPose.m_171419_((float)7.0f, (float)11.0f, (float)-7.0f));
        part.m_171599_(LEFT_HANDLE, CubeListBuilder.m_171558_().m_171514_(64, 0).m_171480_().m_171481_(5.5f, -0.5f, 15.0f, 1.0f, 1.0f, 4.0f), PartPose.m_171419_((float)-7.0f, (float)11.0f, (float)-7.0f));
        part.m_171599_(RIGHT_HANDLE, CubeListBuilder.m_171558_().m_171514_(74, 0).m_171480_().m_171481_(-6.5f, -0.5f, 15.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)7.0f, (float)11.0f, (float)-7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)256, (int)128);
    }

    public CoffinModel(ModelPart part) {
        super(RenderType::m_110446_);
        this.leftPlate = part.m_171324_(LEFT_PLATE);
        this.rightPlate = part.m_171324_(RIGHT_PLATE);
        this.backPlate = part.m_171324_(BACK_PLATE);
        this.topPlate = part.m_171324_(TOP_PLATE);
        this.bottomPlate = part.m_171324_(BOTTOM_PLATE);
        this.leftLid = part.m_171324_(LEFT_LID);
        this.rightLid = part.m_171324_(RIGHT_LID);
        this.leftHandle = part.m_171324_(LEFT_HANDLE);
        this.rightHandle = part.m_171324_(RIGHT_HANDLE);
        this.modelParts = ImmutableList.of((Object)this.leftPlate, (Object)this.rightPlate, (Object)this.backPlate, (Object)this.topPlate, (Object)this.bottomPlate, (Object)this.leftLid, (Object)this.rightLid, (Object)this.leftHandle, (Object)this.rightHandle);
    }

    public void m_7695_(@Nonnull PoseStack matrixStack, @Nonnull VertexConsumer iVertexBuilder, int i, int i1, float v, float v1, float v2, float v3) {
        this.modelParts.forEach(part -> part.m_104306_(matrixStack, iVertexBuilder, i, i1, v, v1, v2, v3));
    }

    public void rotateLid(float angle) {
        this.leftLid.f_104205_ = this.leftHandle.f_104205_ = -angle;
        this.rightLid.f_104205_ = this.rightHandle.f_104205_ = angle;
    }
}

