/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class BaronAttireModel
extends EntityModel<VampireBaronEntity> {
    private static final String HOOD = "hood";
    private static final String CLOAK = "cloak";
    public ModelPart hood;
    public ModelPart cloak;
    private float enragedProgress = 0.0f;

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition hood = part.m_171599_(HOOD, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-4.5f, -8.5f, -4.0f, 9.0f, 9.0f, 9.0f), PartPose.f_171404_);
        hood.m_171599_(CLOAK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.5f, -0.5f, -2.5f, 17.0f, 22.0f, 5.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public BaronAttireModel(ModelPart part) {
        this.hood = part.m_171324_(HOOD);
        this.cloak = this.hood.m_171324_(CLOAK);
    }

    public void prepareMobModel(VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.enragedProgress = entityIn.getEnragedProgress();
    }

    public void m_7695_(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.hood.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(1.0f - 0.4f * this.enragedProgress, 1.0f - 0.7f * this.enragedProgress, 1.0f - 0.4f * this.enragedProgress);
        this.cloak.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85849_();
    }

    public void setupAnim(@Nonnull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float bodyRotateAngleY = 0.0f;
        if (this.f_102608_ > 0.0f) {
            HumanoidArm handside = this.getSwingingSide(entityIn);
            float f1 = this.f_102608_;
            bodyRotateAngleY = Mth.m_14031_((float)(Mth.m_14116_((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HumanoidArm.LEFT) {
                bodyRotateAngleY *= -1.0f;
            }
        }
        this.hood.f_104204_ = bodyRotateAngleY;
        this.cloak.f_104204_ = bodyRotateAngleY;
    }

    protected HumanoidArm getSwingingSide(VampireBaronEntity entity) {
        HumanoidArm handside = entity.m_5737_();
        return entity.f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }
}

