/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.network.AppearancePacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class VampirePlayerAppearanceScreen
extends AppearanceScreen<Player> {
    private static final Component NAME = new TranslatableComponent("gui.vampirism.appearance");
    private float[] color;
    private int fangType;
    private int eyeType;
    private boolean glowingEyes;
    private ScrollableListWidget<Pair<Integer, Component>> eyeList;
    private ScrollableListWidget<Pair<Integer, Component>> fangList;
    private ExtendedButton eyeButton;
    private ExtendedButton fangButton;
    private Checkbox glowingEyesButton;

    public VampirePlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, Minecraft.m_91087_().f_91074_, backScreen);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.fangList.m_7979_(mouseX, mouseY, button, dragX, dragY) && !this.eyeList.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void m_7861_() {
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((Player)this.entity).m_142049_(), "", this.fangType, this.eyeType, this.glowingEyes ? 1 : 0));
        super.m_7861_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        IPlayableFaction<?> f = VampirismPlayerAttributes.get((Player)Minecraft.m_91087_().f_91074_).faction;
        this.color = f == null ? Color.GRAY.getRGBColorComponents() : new Color(f.getColor()).getRGBColorComponents();
        VampirePlayerSpecialAttributes vampAtt = VampirismPlayerAttributes.get((Player)this.f_96541_.f_91074_).getVampSpecial();
        this.fangType = vampAtt.fangType;
        this.eyeType = vampAtt.eyeType;
        this.glowingEyes = vampAtt.glowingEyes;
        this.eyeList = (ScrollableListWidget)this.m_142416_((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 30 + 19, 99, 100, 20, 16, (BaseComponent)new TranslatableComponent("gui.vampirism.appearance.eye"), this::eye, this::hoverEye).scrollSpeed(2.0));
        this.fangList = (ScrollableListWidget)this.m_142416_((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 50 + 19, 99, 80, 20, 7, (BaseComponent)new TranslatableComponent("gui.vampirism.appearance.fang"), this::fang, this::hoverFang));
        this.eyeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.eyeList.f_93620_, this.eyeList.f_93621_ - 20, this.eyeList.m_5711_() + 1, 20, (Component)new TextComponent(""), b -> this.setEyeListVisibility(!this.eyeList.f_93624_)));
        this.fangButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.fangList.f_93620_, this.fangList.f_93621_ - 20, this.fangList.m_5711_() + 1, 20, (Component)new TextComponent(""), b -> this.setFangListVisibility(!this.fangList.f_93624_)));
        this.glowingEyesButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 70, 99, 20, (Component)new TranslatableComponent("gui.vampirism.appearance.glowing_eye"), this.glowingEyes){

            public void m_5691_() {
                super.m_5691_();
                VampirePlayerAppearanceScreen.this.glowingEyes = this.m_93840_();
                VampirePlayer.getOpt((Player)VampirePlayerAppearanceScreen.this.entity).ifPresent(p -> p.setGlowingEyes(VampirePlayerAppearanceScreen.this.glowingEyes));
            }
        });
        this.setEyeListVisibility(false);
        this.setFangListVisibility(false);
    }

    @Override
    protected void renderGuiBackground(PoseStack mStack) {
        RenderSystem.m_157429_((float)this.color[0], (float)this.color[1], (float)this.color[2], (float)1.0f);
        super.renderGuiBackground(mStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void eye(int eyeType) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            this.eyeType = eyeType;
            vampire.setEyeType(this.eyeType);
            this.setEyeListVisibility(false);
        });
    }

    private void fang(int fangType) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            this.fangType = fangType;
            vampire.setFangType(this.fangType);
            this.setFangListVisibility(false);
        });
    }

    private void hoverEye(int eyeType, boolean hovered) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            if (hovered) {
                vampire.setEyeType(eyeType);
            } else if (vampire.getEyeType() == eyeType) {
                vampire.setEyeType(this.eyeType);
            }
        });
    }

    private void hoverFang(int fangType, boolean hovered) {
        VampirePlayer.getOpt((Player)this.f_96541_.f_91074_).ifPresent(vampire -> {
            if (hovered) {
                vampire.setFangType(fangType);
            } else if (vampire.getFangType() == fangType) {
                vampire.setFangType(this.fangType);
            }
        });
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.m_93666_((Component)this.eyeList.m_6035_().m_6881_().m_130946_(" " + (this.eyeType + 1)));
        this.eyeList.f_93624_ = show;
        this.fangButton.f_93624_ = !show;
        boolean bl = this.glowingEyesButton.f_93624_ = !show;
        if (show) {
            this.fangList.f_93624_ = false;
        }
    }

    private void setFangListVisibility(boolean show) {
        this.fangButton.m_93666_((Component)this.fangList.m_6035_().m_6881_().m_130946_(" " + (this.fangType + 1)));
        this.fangList.f_93624_ = show;
        boolean bl = this.glowingEyesButton.f_93624_ = !show;
        if (show) {
            this.eyeList.f_93624_ = false;
        }
    }
}

