/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.GuiPieMenu;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.ActionSelectScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectMinionTaskScreen
extends GuiPieMenu<Entry> {
    public SelectMinionTaskScreen() {
        super(Color.GRAY, (Component)new TranslatableComponent("text.vampirism.minion.give_order"));
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        IPlayableFaction<?> faction;
        if (key == 32 && Minecraft.m_91087_().f_91074_.m_6084_() && (faction = VampirismPlayerAttributes.get((Player)Minecraft.m_91087_().f_91074_).faction) != null) {
            Minecraft.m_91087_().m_91152_(new ActionSelectScreen(new Color(faction.getColor()), false));
        }
        return super.m_7933_(key, scancode, modifiers);
    }

    @Override
    public boolean m_7920_(int key, int scancode, int modifiers) {
        if (ModKeys.MINION.m_90832_(key, scancode) || ModKeys.ACTION.m_90832_(key, scancode)) {
            this.m_7379_();
            if (this.getSelectedElement() >= 0) {
                this.onElementSelected((Entry)this.elements.get(this.getSelectedElement()));
            }
        }
        return false;
    }

    @Override
    protected ResourceLocation getIconLoc(Entry item) {
        return item.getIconLoc();
    }

    @Override
    protected KeyMapping getMenuKeyBinding() {
        return ModKeys.MINION;
    }

    @Override
    protected Component getName(Entry item) {
        return item.getText();
    }

    @Override
    protected void onElementSelected(Entry id) {
        id.onSelected(this);
    }

    @Override
    protected void onGuiInit() {
        this.elements.clear();
        FactionPlayerHandler.getOpt((Player)this.f_96541_.f_91074_).ifPresent(fp -> this.elements.addAll(PlayerMinionController.getAvailableTasks(fp).stream().map(Entry::new).collect(Collectors.toList())));
        this.elements.add(new Entry((Component)new TranslatableComponent("action.vampirism.cancel"), new ResourceLocation("vampirism", "textures/actions/cancel.png"), GuiPieMenu::m_7379_));
        this.elements.add(new Entry((Component)new TranslatableComponent("text.vampirism.minion.call_single"), new ResourceLocation("vampirism", "textures/minion_tasks/recall_single.png"), SelectMinionTaskScreen::callSingle));
        this.elements.add(new Entry((Component)new TranslatableComponent("text.vampirism.minion.call_all"), new ResourceLocation("vampirism", "textures/minion_tasks/recall.png"), SelectMinionTaskScreen::callAll));
        this.elements.add(new Entry((Component)new TranslatableComponent("text.vampirism.minion.respawn"), new ResourceLocation("vampirism", "textures/minion_tasks/respawn.png"), SelectMinionTaskScreen::callRespawn));
    }

    private void callAll() {
        VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(-1, SelectMinionTaskPacket.RECALL));
    }

    private void callRespawn() {
        VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(-1, SelectMinionTaskPacket.RESPAWN));
    }

    private void callSingle() {
        VampirismMod.dispatcher.sendToServer(new InputEventPacket("sm", ""));
    }

    private void sendTask(IMinionTask<?, ?> task) {
        VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(-1, task.getRegistryName()));
    }

    public static class Entry {
        private final Component text;
        private final ResourceLocation loc;
        private final Consumer<SelectMinionTaskScreen> onSelected;

        public Entry(IMinionTask<?, ?> task) {
            this(task.getName(), new ResourceLocation(task.getRegistryName().m_135827_(), "textures/minion_tasks/" + task.getRegistryName().m_135815_() + ".png"), screen -> screen.sendTask(task));
        }

        public Entry(Component text, ResourceLocation icon, Consumer<SelectMinionTaskScreen> onSelected) {
            this.text = text;
            this.loc = icon;
            this.onSelected = onSelected;
        }

        public ResourceLocation getIconLoc() {
            return this.loc;
        }

        public Component getText() {
            return this.text;
        }

        public void onSelected(SelectMinionTaskScreen screen) {
            this.onSelected.accept(screen);
        }
    }
}

