/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.GuiPieMenu;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.SelectMinionTaskScreen;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ActionBindingPacket;
import de.teamlapen.vampirism.network.InputEventPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ActionSelectScreen<T extends IFactionPlayer<T>>
extends GuiPieMenu<IAction<T>> {
    public static final List<IAction<?>> ACTIONORDER = NonNullList.m_122779_();
    private static final IAction<?> fakeAction = new DefaultVampireAction(){

        @Override
        public boolean activate(IVampirePlayer vampire) {
            return true;
        }

        @Override
        public int getCooldown(IVampirePlayer player) {
            return 0;
        }

        @Override
        public String getTranslationKey() {
            return "action.vampirism.cancel";
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    };
    public static IAction<?> SELECTEDACTION;
    private final boolean editActions;
    private IActionHandler<T> actionHandler;

    private static void saveActionOrder() {
        VampirismConfig.CLIENT.actionOrder.set(ACTIONORDER.stream().filter(action -> action != fakeAction).map(action -> action.getRegistryName().toString()).collect(Collectors.toList()));
    }

    public static void loadActionOrder() {
        ArrayList actions = Lists.newArrayList((Iterable)ModRegistries.ACTIONS.getValues());
        ((List)VampirismConfig.CLIENT.actionOrder.get()).stream().map(action -> (IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(action))).filter(Objects::nonNull).forEachOrdered(action -> {
            actions.remove(action);
            ACTIONORDER.add((IAction<?>)action);
        });
        if (!actions.isEmpty()) {
            ACTIONORDER.addAll(actions);
            ActionSelectScreen.saveActionOrder();
        }
    }

    public ActionSelectScreen(Color backgroundColor, boolean edit) {
        super(backgroundColor, (Component)new TranslatableComponent("selectAction"));
        this.editActions = edit;
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (this.editActions && key == 256) {
            this.m_7379_();
            return true;
        }
        if (key == 32 && !this.editActions && FactionPlayerHandler.getOpt((Player)this.f_96541_.f_91074_).map(FactionPlayerHandler::getLordLevel).orElse(0) > 0) {
            this.f_96541_.m_91152_((Screen)new SelectMinionTaskScreen());
        }
        if (this.getSelectedElement() >= 0 && this.checkBinding(binding -> binding.m_90832_(key, scancode))) {
            return true;
        }
        return super.m_7933_(key, scancode, modifiers);
    }

    @Override
    public boolean m_7920_(int key, int scancode, int modifiers) {
        if (!this.editActions && (ModKeys.MINION.m_90832_(key, scancode) || ModKeys.ACTION.m_90832_(key, scancode))) {
            this.m_7379_();
            if (this.getSelectedElement() >= 0) {
                this.onElementSelected((IAction)this.elements.get(this.getSelectedElement()));
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.getSelectedElement() >= 0) {
            if (this.editActions && mouseButton == 0) {
                if (this.elements.get(this.getSelectedElement()) != fakeAction) {
                    SELECTEDACTION = (IAction)this.elements.get(this.getSelectedElement());
                } else {
                    this.m_7379_();
                }
            }
            if (this.checkBinding(binding -> binding.m_90830_(mouseButton))) {
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void m_7379_() {
        if (this.editActions) {
            ActionSelectScreen.saveActionOrder();
            SELECTEDACTION = null;
        }
        super.m_7379_();
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.editActions) {
            if (SELECTEDACTION != null) {
                if (mouseButton == 0 && this.getSelectedElement() >= 0 && this.elements.get(this.getSelectedElement()) != fakeAction) {
                    this.switchActions(SELECTEDACTION, (IAction)this.elements.get(this.getSelectedElement()));
                    this.updateElements();
                }
                SELECTEDACTION = null;
            }
        } else {
            super.m_6348_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    @Override
    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.editActions) {
            ArrayList tooltips = Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("gui.vampirism.action_select.action_binding"), ModKeys.ACTION1.m_90863_().m_6879_().m_130940_(ChatFormatting.AQUA), ModKeys.ACTION2.m_90863_().m_6879_().m_130940_(ChatFormatting.AQUA)});
            this.renderTooltip(stack, tooltips.stream().flatMap(t -> this.f_96547_.m_92923_((FormattedText)t, this.f_96543_ / 4).stream()).collect(Collectors.toList()), 0, (int)((double)this.f_96544_ * 0.82), this.f_96547_);
        }
    }

    @Override
    protected void afterIconDraw(PoseStack stack, IAction<T> p, int x, int y) {
        if (p == fakeAction || this.editActions) {
            return;
        }
        float active = this.actionHandler.getPercentageForAction(p);
        if (active > 0.0f) {
            float h = active * 16.0f;
            this.m_93179_(stack, x, (int)((float)y + h), x + 16, y + 16, Color.YELLOW.getRGB() - -2013265920, Color.YELLOW.getRGB());
        } else if (active < 0.0f) {
            float h = (1.0f + active) * 16.0f;
            this.m_93179_(stack, x, (int)((float)y + h), x + 16, y + 16, Color.BLACK.getRGB() - 0x55000000, Color.BLACK.getRGB());
        }
    }

    @Override
    @Nonnull
    protected Color getColor(IAction<T> s) {
        if (s == fakeAction) {
            return super.getColor(s);
        }
        if (this.editActions) {
            if (SELECTEDACTION != null && (s == SELECTEDACTION || this.getSelectedElement() >= 0 && this.elements.get(this.getSelectedElement()) == s)) {
                return Color.GREEN;
            }
            return Color.WHITE;
        }
        if (!this.f_96541_.f_91074_.m_6084_()) {
            return Color.RED;
        }
        return FactionPlayerHandler.getCurrentFactionPlayer((Player)this.f_96541_.f_91074_).map(factionPlayer -> {
            if (s.canUse(factionPlayer) != IAction.PERM.ALLOWED || this.actionHandler.getPercentageForAction(s) < 0.0f) {
                return Color.RED;
            }
            if (this.actionHandler.getPercentageForAction(s) > 0.0f) {
                return Color.YELLOW;
            }
            return null;
        }).orElse(super.getColor(s));
    }

    @Override
    protected ResourceLocation getIconLoc(IAction<T> item) {
        if (item == fakeAction) {
            return new ResourceLocation("vampirism", "textures/actions/cancel.png");
        }
        return new ResourceLocation(item.getRegistryName().m_135827_(), "textures/actions/" + item.getRegistryName().m_135815_() + ".png");
    }

    @Override
    protected KeyMapping getMenuKeyBinding() {
        return ModKeys.ACTION;
    }

    @Override
    protected Component getName(IAction<T> item) {
        return item.getName();
    }

    @Override
    protected void onElementSelected(IAction<T> action) {
        if (action != fakeAction && action.canUse(FactionPlayerHandler.get((Player)this.f_96541_.f_91074_).getCurrentFactionPlayer().orElse(null)) == IAction.PERM.ALLOWED) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("ta", action.getRegistryName().toString()));
        }
    }

    @Override
    protected void onGuiInit() {
        IFactionPlayer<?> player = FactionPlayerHandler.get((Player)this.f_96541_.f_91074_).getCurrentFactionPlayer().orElseThrow(() -> new NullPointerException("Player can not be null"));
        this.actionHandler = player.getActionHandler();
        this.updateElements();
    }

    private boolean checkBinding(Function<KeyMapping, Boolean> func) {
        if (this.elements.get(this.getSelectedElement()) == fakeAction) {
            return true;
        }
        if (func.apply(ModKeys.ACTION1).booleanValue() && ModKeys.ACTION1.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.setBinding(1);
            return true;
        }
        if (func.apply(ModKeys.ACTION2).booleanValue() && ModKeys.ACTION2.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.setBinding(2);
            return true;
        }
        if (func.apply(ModKeys.ACTION3).booleanValue() && ModKeys.ACTION3.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.setBinding(3);
            return true;
        }
        return false;
    }

    private ImmutableList<IAction<T>> getActionOrdered(List<IAction<T>> toSort) {
        if (ACTIONORDER.isEmpty()) {
            ACTIONORDER.addAll(ModRegistries.ACTIONS.getValues());
        }
        List list = ACTIONORDER.stream().filter(toSort::contains).collect(Collectors.toList());
        toSort.removeAll(list);
        list.addAll(toSort);
        return ImmutableList.copyOf(list);
    }

    private void setBinding(int id) {
        IAction action = (IAction)this.elements.get(this.getSelectedElement());
        FactionPlayerHandler.get((Player)this.f_96541_.f_91074_).setBoundAction(id, action, false, true);
        VampirismMod.dispatcher.sendToServer(new ActionBindingPacket(id, action));
        if (!this.editActions) {
            GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)((float)this.f_96541_.m_91268_().m_85443_() / 2.0f), (double)((float)this.f_96541_.m_91268_().m_85444_() / 2.0f));
            this.m_7379_();
        }
    }

    private void switchActions(IAction<T> first, IAction<T> second) {
        if (first == second) {
            return;
        }
        int a = ACTIONORDER.indexOf(first);
        int b = ACTIONORDER.indexOf(second);
        ACTIONORDER.set(a, second);
        ACTIONORDER.set(b, first);
    }

    private void updateElements() {
        this.elements.clear();
        this.elements.addAll(this.getActionOrdered(this.actionHandler.getUnlockedActions().stream().filter(a -> a.showInSelectAction((Player)this.f_96541_.f_91074_)).collect(Collectors.toList())));
        this.elements.add(fakeAction);
    }
}

