/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.model.blocks.BakedAltarInspirationModel;
import de.teamlapen.vampirism.client.model.blocks.BakedBloodContainerModel;
import de.teamlapen.vampirism.client.model.blocks.BakedWeaponTableModel;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        Object newModel;
        BakedModel registeredModel;
        ArrayList modelLocations;
        Object model;
        ResourceLocation loc;
        try {
            for (int x = 0; x < 14; ++x) {
                loc = new ResourceLocation("vampirism", "block/blood_container/fluid_" + (x + 1));
                model = event.getModelLoader().getModelOrMissing(loc);
                BakedBloodContainerModel.BLOOD_FLUID_MODELS[x] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, loc);
                if (model instanceof BlockModel) {
                    ((BlockModel)model).f_111417_.put("fluid", Either.left((Object)ForgeHooksClient.getBlockMaterial((ResourceLocation)ModFluids.impure_blood.getAttributes().getStillTexture())));
                    BakedBloodContainerModel.IMPURE_BLOOD_FLUID_MODELS[x] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, loc);
                    continue;
                }
                LOGGER.error("Cannot apply impure blood texture to blood container model {}", model);
                BakedBloodContainerModel.IMPURE_BLOOD_FLUID_MODELS[x] = BakedBloodContainerModel.BLOOD_FLUID_MODELS[x];
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.m_135827_().equals("vampirism") || !modelLoc.m_135815_().equals("blood_container")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModelRegistry().get(loc2);
                newModel = new BakedBloodContainerModel(registeredModel);
                event.getModelRegistry().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for blood container", (Throwable)e);
        }
        try {
            for (int x = 0; x < 10; ++x) {
                loc = new ResourceLocation("vampirism", "block/altar_inspiration/blood" + (x + 1));
                model = event.getModelLoader().getModelOrMissing(loc);
                BakedAltarInspirationModel.FLUID_MODELS[x] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, loc);
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.m_135827_().equals("vampirism") || !modelLoc.m_135815_().equals("altar_inspiration")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModelRegistry().get(loc2);
                newModel = new BakedAltarInspirationModel(registeredModel);
                event.getModelRegistry().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for altar inspiration", (Throwable)e);
        }
        try {
            for (int x = 0; x < 5; ++x) {
                loc = new ResourceLocation("vampirism", "block/weapon_table/weapon_table_lava" + (x + 1));
                model = event.getModelLoader().getModelOrMissing(loc);
                BakedWeaponTableModel.FLUID_MODELS[x][0] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y180, loc);
                BakedWeaponTableModel.FLUID_MODELS[x][1] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y270, loc);
                BakedWeaponTableModel.FLUID_MODELS[x][2] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, loc);
                BakedWeaponTableModel.FLUID_MODELS[x][3] = model.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y90, loc);
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.m_135827_().equals("vampirism") || !modelLoc.m_135815_().equals("weapon_table")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModelRegistry().get(loc2);
                newModel = new BakedWeaponTableModel(registeredModel);
                event.getModelRegistry().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for weapon crafting table", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onFovOffsetUpdate(FOVModifierEvent event) {
        if (((Boolean)VampirismConfig.CLIENT.disableFovChange.get()).booleanValue() && Helper.isVampire(event.getEntity())) {
            AttributeInstance speed = event.getEntity().m_21051_(Attributes.f_22279_);
            AttributeModifier vampirespeed = speed.m_22111_(LevelAttributeModifier.getUUID(Attributes.f_22279_));
            if (vampirespeed == null) {
                return;
            }
            event.setNewfov((float)((double)event.getFov() * ((vampirespeed.m_22218_() + 1.0) * (double)event.getEntity().m_150110_().m_35947_() + speed.m_22135_()) / ((vampirespeed.m_22218_() + 1.0) * ((double)event.getEntity().m_150110_().m_35947_() + speed.m_22135_()))));
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        if (VampirismPotion.isHunterPotion(event.getItemStack(), true).map(Potion::m_43488_).map(effectInstances -> effectInstances.stream().map(MobEffectInstance::m_19544_).anyMatch(MobEffect::m_19486_)).orElse(false).booleanValue() && (event.getPlayer() == null || !Helper.isHunter(event.getPlayer()))) {
            event.getToolTip().add(new TranslatableComponent("text.vampirism.hunter_potion.deadly").m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public void onWorldClosed(WorldEvent.Unload event) {
        ((ClientProxy)VampirismMod.proxy).clearBossBarOverlay();
    }
}

