/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;

public class TentBlock
extends VampirismBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty POSITION = IntegerProperty.m_61631_((String)"position", (int)0, (int)3);
    private static final String name = "tent";
    private static final Table<Direction, Integer, VoxelShape> shapes;
    private static final Map<Player.BedSleepingProblem, Component> sleepResults;
    private static final Table<Integer, Direction, Pair<Double, Double>> offsets;

    public static void setTentSleepPosition(Player player, BlockPos blockPos, int position, Direction facing) {
        player.m_6034_((double)blockPos.m_123341_() + (Double)((Pair)offsets.get((Object)position, (Object)facing)).getFirst(), (double)blockPos.m_123342_() + 0.0625, (double)blockPos.m_123343_() + (Double)((Pair)offsets.get((Object)position, (Object)facing)).getSecond());
    }

    private static VoxelShape makeShape() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)1.0, (double)0.0, (double)1.4, (double)1.45, (double)16.0), Block.m_49796_((double)0.9, (double)1.4, (double)0.0, (double)1.8, (double)1.85, (double)16.0), Block.m_49796_((double)1.3, (double)1.8, (double)0.0, (double)2.2, (double)2.25, (double)16.0), Block.m_49796_((double)1.7, (double)2.2, (double)0.0, (double)2.6, (double)2.65, (double)16.0), Block.m_49796_((double)2.1, (double)2.6, (double)0.0, (double)3.0, (double)3.05, (double)16.0), Block.m_49796_((double)2.5, (double)3.0, (double)0.0, (double)3.4, (double)3.45, (double)16.0), Block.m_49796_((double)2.9, (double)3.4, (double)0.0, (double)3.8, (double)3.85, (double)16.0), Block.m_49796_((double)3.3, (double)3.8, (double)0.0, (double)4.2, (double)4.25, (double)16.0), Block.m_49796_((double)3.7, (double)4.2, (double)0.0, (double)4.6, (double)4.65, (double)16.0), Block.m_49796_((double)4.1, (double)4.6, (double)0.0, (double)5.0, (double)5.05, (double)16.0), Block.m_49796_((double)4.5, (double)5.0, (double)0.0, (double)5.4, (double)5.45, (double)16.0), Block.m_49796_((double)4.9, (double)5.4, (double)0.0, (double)5.8, (double)5.85, (double)16.0), Block.m_49796_((double)5.3, (double)5.8, (double)0.0, (double)6.2, (double)6.25, (double)16.0), Block.m_49796_((double)5.7, (double)6.2, (double)0.0, (double)6.6, (double)6.65, (double)16.0), Block.m_49796_((double)6.1, (double)6.6, (double)0.0, (double)7.0, (double)7.05, (double)16.0), Block.m_49796_((double)6.5, (double)7.0, (double)0.0, (double)7.4, (double)7.45, (double)16.0), Block.m_49796_((double)6.9, (double)7.4, (double)0.0, (double)7.8, (double)7.85, (double)16.0), Block.m_49796_((double)7.3, (double)7.8, (double)0.0, (double)8.2, (double)8.25, (double)16.0), Block.m_49796_((double)7.7, (double)8.2, (double)0.0, (double)8.6, (double)8.65, (double)16.0), Block.m_49796_((double)8.1, (double)8.6, (double)0.0, (double)9.0, (double)9.05, (double)16.0), Block.m_49796_((double)8.5, (double)9.0, (double)0.0, (double)9.4, (double)9.45, (double)16.0), Block.m_49796_((double)8.9, (double)9.4, (double)0.0, (double)9.8, (double)9.85, (double)16.0), Block.m_49796_((double)9.3, (double)9.8, (double)0.0, (double)10.2, (double)10.25, (double)16.0), Block.m_49796_((double)9.7, (double)10.2, (double)0.0, (double)10.6, (double)10.65, (double)16.0), Block.m_49796_((double)10.1, (double)10.6, (double)0.0, (double)11.0, (double)11.05, (double)16.0), Block.m_49796_((double)10.5, (double)11.0, (double)0.0, (double)11.4, (double)11.45, (double)16.0), Block.m_49796_((double)10.9, (double)11.4, (double)0.0, (double)11.8, (double)11.85, (double)16.0), Block.m_49796_((double)11.3, (double)11.8, (double)0.0, (double)12.2, (double)12.25, (double)16.0), Block.m_49796_((double)11.7, (double)12.2, (double)0.0, (double)12.6, (double)12.65, (double)16.0), Block.m_49796_((double)12.1, (double)12.6, (double)0.0, (double)13.0, (double)13.05, (double)16.0), Block.m_49796_((double)12.5, (double)13.0, (double)0.0, (double)13.4, (double)13.45, (double)16.0), Block.m_49796_((double)12.9, (double)13.4, (double)0.0, (double)13.8, (double)13.85, (double)16.0), Block.m_49796_((double)13.3, (double)13.8, (double)0.0, (double)14.2, (double)14.25, (double)16.0), Block.m_49796_((double)13.7, (double)14.2, (double)0.0, (double)14.6, (double)14.65, (double)16.0), Block.m_49796_((double)14.1, (double)14.6, (double)0.0, (double)15.0, (double)15.05, (double)16.0), Block.m_49796_((double)14.5, (double)15.0, (double)0.0, (double)15.4, (double)15.45, (double)16.0), Block.m_49796_((double)14.9, (double)15.4, (double)0.0, (double)15.8, (double)15.85, (double)16.0), Block.m_49796_((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    }

    private static VoxelShape makeShapeBack2() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.85, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)14.65, (double)1.0), Block.m_49796_((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)13.85, (double)1.0), Block.m_49796_((double)12.0, (double)1.0, (double)0.0, (double)13.0, (double)12.65, (double)1.0), Block.m_49796_((double)11.0, (double)1.0, (double)0.0, (double)12.0, (double)11.85, (double)1.0), Block.m_49796_((double)10.0, (double)1.0, (double)0.0, (double)11.0, (double)10.65, (double)1.0), Block.m_49796_((double)9.0, (double)1.0, (double)0.0, (double)10.0, (double)9.85, (double)1.0), Block.m_49796_((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)8.65, (double)1.0), Block.m_49796_((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)7.85, (double)1.0), Block.m_49796_((double)6.0, (double)1.0, (double)0.0, (double)7.0, (double)6.65, (double)1.0), Block.m_49796_((double)5.0, (double)1.0, (double)0.0, (double)6.0, (double)5.85, (double)1.0), Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)5.0, (double)4.65, (double)1.0), Block.m_49796_((double)3.0, (double)1.0, (double)0.0, (double)4.0, (double)3.85, (double)1.0), Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)2.65, (double)1.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)1.85, (double)1.0)});
    }

    private static VoxelShape makeShapeBack1() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)1.85, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)2.65, (double)1.0), Block.m_49796_((double)12.0, (double)1.0, (double)0.0, (double)13.0, (double)3.85, (double)1.0), Block.m_49796_((double)11.0, (double)1.0, (double)0.0, (double)12.0, (double)4.65, (double)1.0), Block.m_49796_((double)10.0, (double)1.0, (double)0.0, (double)11.0, (double)5.85, (double)1.0), Block.m_49796_((double)9.0, (double)1.0, (double)0.0, (double)10.0, (double)6.65, (double)1.0), Block.m_49796_((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)7.85, (double)1.0), Block.m_49796_((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)8.65, (double)1.0), Block.m_49796_((double)6.0, (double)1.0, (double)0.0, (double)7.0, (double)9.85, (double)1.0), Block.m_49796_((double)5.0, (double)1.0, (double)0.0, (double)6.0, (double)10.65, (double)1.0), Block.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)5.0, (double)11.85, (double)1.0), Block.m_49796_((double)3.0, (double)1.0, (double)0.0, (double)4.0, (double)12.65, (double)1.0), Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)13.85, (double)1.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)14.65, (double)1.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.85, (double)1.0)});
    }

    public TentBlock() {
        this(name);
    }

    protected TentBlock(String name) {
        super(name, BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(0.6f).m_60918_(SoundType.f_56745_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POSITION, (Comparable)Integer.valueOf(0))).m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new IBlockRenderProperties(){

            public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
                return true;
            }
        });
    }

    public boolean m_7898_(@Nonnull BlockState blockState, LevelReader worldReader, @Nonnull BlockPos blockPos) {
        return worldReader.m_8055_(blockPos).m_60795_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.item_tent);
    }

    public void m_142072_(@Nonnull Level worldIn, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance * 0.7f);
    }

    public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public Direction getBedDirection(BlockState state, LevelReader world, BlockPos pos) {
        return switch ((Integer)state.m_61143_((Property)POSITION)) {
            case 0, 3 -> ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
            default -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        };
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, @Nonnull BlockGetter blockReader, @Nonnull BlockPos blockPos, @Nonnull CollisionContext context) {
        return (VoxelShape)shapes.get((Object)blockState.m_61143_((Property)FACING), (Object)blockState.m_61143_((Property)POSITION));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction thisFacing = (Direction)stateIn.m_61143_((Property)FACING);
        int thisPos = (Integer)stateIn.m_61143_((Property)POSITION);
        if (facing == thisFacing.m_122427_() || (thisPos == 0 || thisPos == 2) && facing == thisFacing.m_122424_() || (thisPos == 1 || thisPos == 3) && facing == thisFacing) {
            return facingState.m_60734_() instanceof TentBlock ? (BlockState)stateIn.m_61124_((Property)BedBlock.f_49441_, (Comparable)((Boolean)facingState.m_61143_((Property)BedBlock.f_49441_))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_5707_(Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        if (!worldIn.f_46443_ && player.m_7500_()) {
            Direction thisFacing = (Direction)state.m_61143_((Property)FACING);
            int thisPos = (Integer)state.m_61143_((Property)POSITION);
            if (thisPos != 0) {
                BlockState blockstate;
                BlockPos main = null;
                switch (thisPos) {
                    case 1: {
                        main = pos.m_142300_(thisFacing.m_122427_());
                        break;
                    }
                    case 2: {
                        main = pos.m_142300_(thisFacing.m_122424_()).m_142300_(thisFacing.m_122427_());
                        break;
                    }
                    case 3: {
                        main = pos.m_142300_(thisFacing);
                    }
                }
                if (main != null && (blockstate = worldIn.m_8055_(main)).m_60734_() == ModBlocks.tent_main) {
                    worldIn.m_7731_(main, Blocks.f_50016_.m_49966_(), 35);
                    worldIn.m_5898_(player, 2001, main, Block.m_49956_((BlockState)blockstate));
                }
            }
        }
    }

    public void m_5548_(@Nonnull BlockGetter worldIn, Entity entityIn) {
        if (entityIn.m_6144_()) {
            super.m_5548_(worldIn, entityIn);
        } else {
            Vec3 vec3d = entityIn.m_20184_();
            if (vec3d.f_82480_ < 0.0) {
                double d0 = entityIn instanceof LivingEntity ? 1.0 : 0.8;
                entityIn.m_20334_(vec3d.f_82479_, -vec3d.f_82480_ * (double)0.33f * d0, vec3d.f_82481_);
            }
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState blockState, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult rayTraceResult) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (VampirismPlayerAttributes.get((Player)player).hunterLevel == 0) {
            player.m_5661_((Component)new TranslatableComponent("text.vampirism.tent.cant_use"), true);
            return InteractionResult.SUCCESS;
        }
        if (!BedBlock.m_49488_((Level)world)) {
            world.m_7471_(pos, false);
            BlockPos blockpos = pos.m_142300_(((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
            if (world.m_8055_(blockpos).m_60713_((Block)this)) {
                world.m_7471_(blockpos, false);
            }
            world.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)blockState.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            player.m_5661_((Component)new TranslatableComponent("text.vampirism.tent.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(pos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.m_5661_(sleepResults.getOrDefault(sleepResult1, sleepResult1.m_36423_()), true);
            }
        }).ifRight(u -> {
            this.setBedOccupied(blockState, world, pos, null, true);
            TentBlock.setTentSleepPosition(player, pos, (Integer)player.f_19853_.m_8055_(pos).m_61143_((Property)POSITION), (Direction)player.f_19853_.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61374_));
        });
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POSITION, BlockStateProperties.f_61445_});
    }

    static {
        VoxelShape NORTH = TentBlock.makeShape();
        VoxelShape EAST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.NINETY);
        VoxelShape SOUTH = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        VoxelShape WEST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        VoxelShape BACK = TentBlock.makeShapeBack1();
        VoxelShape BACKMIRROR = TentBlock.makeShapeBack2();
        VoxelShape SOUTHR = Shapes.m_83110_((VoxelShape)SOUTH, (VoxelShape)BACK);
        VoxelShape NORTHL = Shapes.m_83110_((VoxelShape)NORTH, (VoxelShape)BACKMIRROR);
        ImmutableTable.Builder shapeBuilder = ImmutableTable.builder();
        shapeBuilder.put((Object)Direction.NORTH, (Object)0, (Object)NORTH);
        shapeBuilder.put((Object)Direction.NORTH, (Object)1, (Object)NORTH);
        shapeBuilder.put((Object)Direction.NORTH, (Object)2, (Object)NORTHL);
        shapeBuilder.put((Object)Direction.NORTH, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.HUNDRED_EIGHTY));
        shapeBuilder.put((Object)Direction.EAST, (Object)0, (Object)EAST);
        shapeBuilder.put((Object)Direction.EAST, (Object)1, (Object)EAST);
        shapeBuilder.put((Object)Direction.EAST, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.NINETY));
        shapeBuilder.put((Object)Direction.EAST, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        shapeBuilder.put((Object)Direction.SOUTH, (Object)0, (Object)SOUTH);
        shapeBuilder.put((Object)Direction.SOUTH, (Object)1, (Object)SOUTH);
        shapeBuilder.put((Object)Direction.SOUTH, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.HUNDRED_EIGHTY));
        shapeBuilder.put((Object)Direction.SOUTH, (Object)3, (Object)SOUTHR);
        shapeBuilder.put((Object)Direction.WEST, (Object)0, (Object)WEST);
        shapeBuilder.put((Object)Direction.WEST, (Object)1, (Object)WEST);
        shapeBuilder.put((Object)Direction.WEST, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        shapeBuilder.put((Object)Direction.WEST, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.NINETY));
        shapes = shapeBuilder.build();
        ImmutableTable.Builder offsetsBuilder = ImmutableTable.builder();
        offsetsBuilder.put((Object)0, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)1.6));
        offsetsBuilder.put((Object)0, (Object)Direction.EAST, (Object)Pair.of((Object)-0.6, (Object)1.0));
        offsetsBuilder.put((Object)0, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)-0.6));
        offsetsBuilder.put((Object)0, (Object)Direction.WEST, (Object)Pair.of((Object)1.6, (Object)0.0));
        offsetsBuilder.put((Object)1, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)-0.6));
        offsetsBuilder.put((Object)1, (Object)Direction.EAST, (Object)Pair.of((Object)1.6, (Object)1.0));
        offsetsBuilder.put((Object)1, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)1.6));
        offsetsBuilder.put((Object)1, (Object)Direction.WEST, (Object)Pair.of((Object)-0.6, (Object)0.0));
        offsetsBuilder.put((Object)2, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)0.4));
        offsetsBuilder.put((Object)2, (Object)Direction.EAST, (Object)Pair.of((Object)0.6, (Object)1.0));
        offsetsBuilder.put((Object)2, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)0.6));
        offsetsBuilder.put((Object)2, (Object)Direction.WEST, (Object)Pair.of((Object)0.4, (Object)0.0));
        offsetsBuilder.put((Object)3, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)0.6));
        offsetsBuilder.put((Object)3, (Object)Direction.EAST, (Object)Pair.of((Object)0.4, (Object)1.0));
        offsetsBuilder.put((Object)3, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)0.4));
        offsetsBuilder.put((Object)3, (Object)Direction.WEST, (Object)Pair.of((Object)0.6, (Object)0.0));
        offsets = offsetsBuilder.build();
        ImmutableMap.Builder sleepBuilder = ImmutableMap.builder();
        sleepBuilder.put((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW, (Object)new TranslatableComponent("text.vampirism.tent.no_sleep"));
        sleepBuilder.put((Object)Player.BedSleepingProblem.TOO_FAR_AWAY, (Object)new TranslatableComponent("text.vampirism.tent.too_far_away"));
        sleepBuilder.put((Object)Player.BedSleepingProblem.OBSTRUCTED, (Object)new TranslatableComponent("text.vampirism.tent.obstructed"));
        sleepResults = sleepBuilder.build();
    }
}

