/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blockentity.PedestalBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PedestalBlock
extends VampirismBlockContainer {
    public static final String regName = "blood_pedestal";
    private static final VoxelShape pedestalShape = PedestalBlock.makeShape();

    private static void takeItemPlayer(Player player, InteractionHand hand, ItemStack stack) {
        player.m_21008_(hand, stack);
        if (stack.m_41720_() instanceof VampirismVampireSword && ((VampirismVampireSword)stack.m_41720_()).isFullyCharged(stack)) {
            ((VampirismVampireSword)stack.m_41720_()).tryName(stack, player);
        }
    }

    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
        VoxelShape b = Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
        VoxelShape c = Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
        VoxelShape d = Block.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0);
        VoxelShape e = Block.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
        VoxelShape f = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape g1 = Block.m_49796_((double)4.0, (double)9.0, (double)4.0, (double)5.0, (double)11.0, (double)5.0);
        VoxelShape g2 = Block.m_49796_((double)11.0, (double)9.0, (double)4.0, (double)12.0, (double)11.0, (double)5.0);
        VoxelShape g3 = Block.m_49796_((double)4.0, (double)9.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0);
        VoxelShape g4 = Block.m_49796_((double)11.0, (double)9.0, (double)11.0, (double)12.0, (double)11.0, (double)12.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e, f, g1, g2, g3, g4});
    }

    public PedestalBlock() {
        super(regName, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60955_());
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return pedestalShape;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        PedestalBlockEntity tile = this.getTileEntity((BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() && !tile.extractItem(0, 1, true).m_41619_()) {
            ItemStack stack2 = tile.extractItem(0, 1, false);
            PedestalBlock.takeItemPlayer(player, hand, stack2);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_()) {
            ItemStack stack2 = ItemStack.f_41583_;
            if (!tile.extractItem(0, 1, true).m_41619_()) {
                stack2 = tile.extractItem(0, 1, false);
            }
            if (tile.insertItem(0, stack, false).m_41619_()) {
                if (!stack.m_41619_()) {
                    PedestalBlock.takeItemPlayer(player, hand, stack2);
                }
            } else {
                tile.insertItem(0, stack2, false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    protected void clearContainer(BlockState state, Level worldIn, BlockPos pos) {
        PedestalBlockEntity tile = this.getTileEntity((BlockGetter)worldIn, pos);
        if (tile != null && tile.hasStack()) {
            this.dropItem(worldIn, pos, tile.removeStack());
        }
    }

    @Nullable
    private PedestalBlockEntity getTileEntity(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof PedestalBlockEntity) {
            return (PedestalBlockEntity)tile;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return PedestalBlock.m_152132_(type, ModTiles.blood_pedestal, (BlockEntityTicker)(level.m_5776_() ? PedestalBlockEntity::clientTick : PedestalBlockEntity::serverTick));
    }
}

