/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MedChairBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.m_61587_((String)"part", EnumPart.class);
    private static final String name = "med_chair";
    private final VoxelShape SHAPE_TOP;
    private final VoxelShape SHAPE_BOTTOM;

    public MedChairBlock() {
        super(name, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)EnumPart.TOP)));
        this.SHAPE_TOP = MedChairBlock.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
        this.SHAPE_BOTTOM = MedChairBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    }

    @Nonnull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.item_med_chair);
    }

    @Override
    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.m_61143_(PART) == EnumPart.BOTTOM ? this.SHAPE_BOTTOM : this.SHAPE_TOP;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == MedChairBlock.getDirectionToOther((EnumPart)((Object)pState.m_61143_(PART)), (Direction)pState.m_61143_((Property)FACING))) {
            return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(PART) != pState.m_61143_(PART) ? pState : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private static Direction getDirectionToOther(EnumPart type, Direction facing) {
        return type == EnumPart.TOP ? facing : facing.m_122424_();
    }

    public void m_5707_(@Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        BlockPos other;
        BlockState otherState;
        EnumPart part;
        if (!worldIn.f_46443_ && player.m_7500_() && (part = (EnumPart)((Object)state.m_61143_(PART))) == EnumPart.BOTTOM && (otherState = worldIn.m_8055_(other = pos.m_142300_(MedChairBlock.getDirectionToOther((EnumPart)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)FACING))))).m_60734_() == this && otherState.m_61143_(PART) == EnumPart.TOP) {
            worldIn.m_7731_(other, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, other, Block.m_49956_((BlockState)otherState));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (player.m_6084_()) {
            ItemStack stack = player.m_21120_(hand);
            if (this.handleInjections(player, world, stack)) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_150109_().m_36057_(stack);
                }
            }
        } else if (world.f_46443_) {
            player.m_5661_((Component)new TranslatableComponent("text.vampirism.need_item_to_use", new Object[]{new TranslatableComponent(new ItemStack((ItemLike)ModItems.injection_garlic).m_41778_())}), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    private boolean handleGarlicInjection(@Nonnull Player player, @Nonnull Level world, @Nonnull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (handler.canJoin(VReference.HUNTER_FACTION)) {
            if (world.f_46443_) {
                VampirismMod.proxy.renderScreenFullColor(4, 30, -1145324545);
            } else {
                handler.joinFaction(VReference.HUNTER_FACTION);
                player.m_7292_(new MobEffectInstance(ModEffects.poison, 200, 1));
            }
            return true;
        }
        if (currentFaction != null && !world.f_46443_) {
            player.m_6352_((Component)new TranslatableComponent("text.vampirism.med_chair_other_faction", new Object[]{currentFaction.getName()}), Util.f_137441_);
        }
        return false;
    }

    private boolean handleInjections(Player player, Level world, ItemStack stack) {
        return FactionPlayerHandler.getOpt(player).map(handler -> {
            IPlayableFaction<?> faction = handler.getCurrentFaction();
            if (stack.m_41720_().equals((Object)ModItems.injection_garlic)) {
                return this.handleGarlicInjection(player, world, (IFactionPlayerHandler)handler, faction);
            }
            if (stack.m_41720_().equals((Object)ModItems.injection_sanguinare)) {
                return this.handleSanguinareInjection(player, (IFactionPlayerHandler)handler, faction);
            }
            if (stack.m_41720_().equals((Object)ModItems.injection_zombie_blood)) {
                return this.handleZombieBloodInjection(player);
            }
            return false;
        }).orElse(false);
    }

    private boolean handleSanguinareInjection(@Nonnull Player player, @Nonnull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (VReference.VAMPIRE_FACTION.equals(currentFaction)) {
            player.m_5661_((Component)new TranslatableComponent("text.vampirism.already_vampire"), false);
            return false;
        }
        if (VReference.HUNTER_FACTION.equals(currentFaction)) {
            if (player.f_19853_.m_5776_()) {
                VampirismMod.proxy.displayRevertBackScreen();
            }
            return true;
        }
        if (currentFaction == null && handler.canJoin(VReference.VAMPIRE_FACTION)) {
            if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                player.m_5661_((Component)new TranslatableComponent("text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                SanguinareEffect.addRandom((LivingEntity)player, true);
                player.m_7292_(new MobEffectInstance(ModEffects.poison, 60));
                return true;
            }
        }
        return false;
    }

    private boolean handleZombieBloodInjection(@Nonnull Player player) {
        player.m_7292_(new MobEffectInstance(ModEffects.poison, 200));
        return true;
    }

    public static enum EnumPart implements StringRepresentable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        public final String name;
        public final int meta;

        public static EnumPart fromMeta(int meta) {
            if (meta == 1) {
                return BOTTOM;
            }
            return TOP;
        }

        private EnumPart(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

