/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.BloodGrinderBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrinderBlock
extends VampirismBlockContainer {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final String regName = "blood_grinder";
    private static final VoxelShape SOUTH = GrinderBlock.makeShape();
    private static final VoxelShape WEST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape NORTH = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape EAST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);

    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape b = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
        VoxelShape b1 = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)3.0, (double)4.0, (double)3.0);
        VoxelShape b2 = Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)3.0);
        VoxelShape b3 = Block.m_49796_((double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)4.0, (double)14.0);
        VoxelShape b4 = Block.m_49796_((double)13.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)14.0);
        VoxelShape c = Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
        VoxelShape d1 = Block.m_49796_((double)5.0, (double)7.0, (double)2.0, (double)11.0, (double)12.0, (double)14.0);
        VoxelShape d2 = Block.m_49796_((double)2.0, (double)7.0, (double)5.0, (double)14.0, (double)12.0, (double)11.0);
        VoxelShape d3 = Block.m_49796_((double)3.0, (double)7.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0);
        VoxelShape d4 = Block.m_49796_((double)4.0, (double)7.0, (double)3.0, (double)12.0, (double)12.0, (double)13.0);
        VoxelShape d5 = Shapes.m_83110_((VoxelShape)d1, (VoxelShape)d2);
        VoxelShape d6 = Shapes.m_83110_((VoxelShape)d3, (VoxelShape)d4);
        VoxelShape d = Shapes.m_83110_((VoxelShape)d5, (VoxelShape)d6);
        VoxelShape e = Block.m_49796_((double)8.0, (double)12.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape e1 = Block.m_49796_((double)4.0, (double)12.0, (double)5.0, (double)7.0, (double)13.0, (double)6.0);
        VoxelShape e2 = Block.m_49796_((double)5.0, (double)12.0, (double)4.0, (double)6.0, (double)13.0, (double)7.0);
        VoxelShape e3 = Shapes.m_83110_((VoxelShape)e1, (VoxelShape)e2);
        VoxelShape e4 = Shapes.m_83110_((VoxelShape)e, (VoxelShape)e3);
        VoxelShape f = Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
        VoxelShape g = Shapes.m_83110_((VoxelShape)c, (VoxelShape)d);
        VoxelShape g1 = Shapes.m_83110_((VoxelShape)b1, (VoxelShape)b2);
        VoxelShape g2 = Shapes.m_83110_((VoxelShape)b3, (VoxelShape)b4);
        VoxelShape g3 = Shapes.m_83110_((VoxelShape)g1, (VoxelShape)g2);
        VoxelShape g4 = Shapes.m_83110_((VoxelShape)g, (VoxelShape)g3);
        VoxelShape h = Shapes.m_83110_((VoxelShape)f, (VoxelShape)g4);
        return Shapes.m_83110_((VoxelShape)h, (VoxelShape)e4);
    }

    public GrinderBlock() {
        super(regName, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new BloodGrinderBlockEntity(pos, state);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(world.m_7702_(pos) instanceof BloodGrinderBlockEntity ? (BloodGrinderBlockEntity)world.m_7702_(pos) : null);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void clearContainer(BlockState state, Level worldIn, BlockPos pos) {
        this.dropInventoryTileEntityItems(worldIn, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, @Nonnull BlockState p_153213_, @Nonnull BlockEntityType<T> p_153214_) {
        return p_153212_.m_5776_() ? null : GrinderBlock.m_152132_(p_153214_, ModTiles.grinder, BloodGrinderBlockEntity::serverTick);
    }
}

