/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.CoffinBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoffinBlock
extends VampirismBlockContainer {
    public static final String name = "coffin";
    public static final EnumProperty<CoffinPart> PART = EnumProperty.m_61587_((String)"part", CoffinPart.class);
    private static final VoxelShape shape = CoffinBlock.makeShape();
    private static final Map<Player.BedSleepingProblem, Component> sleepResults = ImmutableMap.of((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW, (Object)new TranslatableComponent("text.vampirism.coffin.no_sleep"), (Object)Player.BedSleepingProblem.TOO_FAR_AWAY, (Object)new TranslatableComponent("text.vampirism.coffin.too_far_away"), (Object)Player.BedSleepingProblem.OBSTRUCTED, (Object)new TranslatableComponent("text.vampirism.coffin.obstructed"));

    public static boolean isOccupied(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof CoffinBlock && (Boolean)state.m_61143_((Property)BedBlock.f_49441_) != false;
    }

    public static boolean isHead(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof CoffinBlock && state.m_61143_(PART) == CoffinPart.HEAD;
    }

    private static Direction getDirectionToOther(CoffinPart type, Direction facing) {
        return type == CoffinPart.FOOT ? facing : facing.m_122424_();
    }

    private static VoxelShape makeShape() {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    }

    public CoffinBlock() {
        super(name, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.2f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.FALSE)).m_61124_(PART, (Comparable)((Object)CoffinPart.FOOT))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    public Direction getBedDirection(BlockState state, LevelReader world, BlockPos pos) {
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction enumfacing = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_142300_(enumfacing);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)enumfacing) : null;
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return shape;
    }

    public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, Entity player) {
        return true;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CoffinBlockEntity(pos, state);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, @Nonnull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        CoffinPart part;
        if (!worldIn.f_46443_ && player.m_7500_() && (part = (CoffinPart)((Object)state.m_61143_(PART))) == CoffinPart.FOOT && (blockstate = worldIn.m_8055_(blockpos = pos.m_142300_(CoffinBlock.getDirectionToOther(part, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))))).m_60734_() == this && blockstate.m_61143_(PART) == CoffinPart.HEAD) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6402_(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack itemStack) {
        super.m_6402_(worldIn, pos, state, entity, itemStack);
        if (!worldIn.f_46443_) {
            BlockPos blockpos = pos.m_142300_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
            worldIn.m_7731_(blockpos, (BlockState)state.m_61124_(PART, (Comparable)((Object)CoffinPart.HEAD)), 3);
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (facing == CoffinBlock.getDirectionToOther((CoffinPart)((Object)stateIn.m_61143_(PART)), (Direction)stateIn.m_61143_((Property)BlockStateProperties.f_61374_))) {
            return facingState.m_60734_() == this && facingState.m_61143_(PART) != stateIn.m_61143_(PART) ? (BlockState)stateIn.m_61124_((Property)BedBlock.f_49441_, (Comparable)((Boolean)facingState.m_61143_((Property)BedBlock.f_49441_))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            DyeColor color;
            DyeColor dyeColor = color = heldItem.m_41720_() instanceof DyeItem ? ((DyeItem)heldItem.m_41720_()).m_41089_() : UtilLib.getColorForItem(heldItem.m_41720_());
            if (color != null) {
                BlockEntity other;
                BlockEntity tile = worldIn.m_7702_(pos);
                BlockEntity blockEntity = other = state.m_61143_(PART) == CoffinPart.HEAD ? worldIn.m_7702_(pos.m_142300_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_())) : worldIn.m_7702_(pos.m_142300_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
                if (!(tile instanceof CoffinBlockEntity) || !(other instanceof CoffinBlockEntity)) {
                    return InteractionResult.SUCCESS;
                }
                ((CoffinBlockEntity)tile).changeColor(color);
                ((CoffinBlockEntity)other).changeColor(color);
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (state.m_61143_(PART) != CoffinPart.HEAD && !(state = worldIn.m_8055_(pos = pos.m_142300_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)))).m_60713_((Block)this)) {
            return InteractionResult.SUCCESS;
        }
        if (VampirismPlayerAttributes.get((Player)player).vampireLevel == 0) {
            player.m_5661_((Component)new TranslatableComponent("text.vampirism.coffin.cant_use"), true);
            return InteractionResult.SUCCESS;
        }
        if (!BedBlock.m_49488_((Level)worldIn)) {
            worldIn.m_7471_(pos, false);
            BlockPos blockpos = pos.m_142300_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
            if (worldIn.m_8055_(blockpos).m_60713_((Block)this)) {
                worldIn.m_7471_(blockpos, false);
            }
            worldIn.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            player.m_5661_((Component)new TranslatableComponent("text.vampirism.coffin.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        BlockPos finalPos = pos;
        player.m_7720_(pos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.m_5661_(sleepResults.getOrDefault(sleepResult1, sleepResult1.m_36423_()), true);
            }
        }).ifRight(u -> {
            BlockState blockstate = worldIn.m_8055_(finalPos);
            if (blockstate.m_60734_() instanceof CoffinBlock) {
                worldIn.m_7731_(finalPos, (BlockState)blockstate.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.TRUE), 3);
            }
        });
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BedBlock.f_49441_, PART});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntity) {
        return level.m_5776_() && state.m_61143_(PART) == CoffinPart.HEAD ? CoffinBlock.m_152132_(blockEntity, ModTiles.coffin, CoffinBlockEntity::clientTickHead) : null;
    }

    public static enum CoffinPart implements StringRepresentable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private CoffinPart(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

