/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.BloodContainerBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodContainerBlock
extends VampirismBlockContainer {
    public static final String regName = "blood_container";
    @ObjectHolder(value="vampirism:blood_container")
    public static final Item item = (Item)UtilLib.getNull();
    protected static final VoxelShape containerShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Logger LOGGER = LogManager.getLogger();

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (stack.m_41720_() == item) {
            if (stack.m_41782_() && stack.m_41783_().m_128425_("fluid", 10)) {
                CompoundTag fluidTag = stack.m_41783_().m_128469_("fluid");
                return FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTag);
            }
            return new FluidStack(ModFluids.blood, 0);
        }
        return FluidStack.EMPTY;
    }

    public static void writeFluidToItemStack(ItemStack stack, FluidStack fluid) {
        if (fluid.isEmpty()) {
            if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid")) {
                stack.m_41783_().m_128473_("fluid");
            }
        } else {
            stack.m_41700_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
    }

    public BloodContainerBlock() {
        super(regName, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(1.0f).m_60955_());
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        CompoundTag nbt;
        FluidStack fluid;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid") && (fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)(nbt = stack.m_41783_().m_128469_("fluid")))) != null) {
            tooltip.add((Component)new TranslatableComponent(fluid.getTranslationKey()).m_7220_((Component)new TextComponent(": " + fluid.getAmount() + "mB")).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        super.m_49811_(group, items);
        ItemStack stack = new ItemStack((ItemLike)this, 1);
        FluidStack fluid = new FluidStack(ModFluids.blood, 12600);
        stack.m_41700_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
        items.add((Object)stack);
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new BloodContainerBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return containerShape;
    }

    public void m_6240_(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack heldStack) {
        FluidStack fluid;
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.blood_container, 1);
        if (te != null && !(fluid = ((BloodContainerBlockEntity)te).getFluid()).isEmpty() && fluid.getAmount() >= 100) {
            BloodContainerBlock.writeFluidToItemStack(stack, fluid);
        }
        BloodContainerBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    public void m_6402_(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity tile;
        super.m_6402_(worldIn, pos, state, placer, stack);
        FluidStack fluid = BloodContainerBlock.getFluidFromItemStack(stack);
        if (!stack.m_41619_() && (tile = worldIn.m_7702_(pos)) instanceof BloodContainerBlockEntity) {
            ((BloodContainerBlockEntity)tile).setFluidStack(fluid);
            tile.m_6596_();
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player playerIn, @Nonnull InteractionHand hand, BlockHitResult hit) {
        if (!FluidUtil.interactWithFluidHandler((Player)playerIn, (InteractionHand)hand, (Level)worldIn, (BlockPos)pos, (Direction)hit.m_82434_()) && playerIn.m_21120_(hand).m_41720_().equals(Items.f_42590_) && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
            FluidUtil.getFluidHandler((Level)worldIn, (BlockPos)pos, (Direction)hit.m_82434_()).ifPresent(fluidHandler -> {
                if (fluidHandler.getFluidInTank(0).getFluid().equals(ModFluids.blood)) {
                    ItemStack glass = playerIn.m_21120_(hand);
                    ItemStack bloodBottle = new ItemStack((ItemLike)ModItems.blood_bottle, 1);
                    playerIn.m_21008_(hand, bloodBottle);
                    bloodBottle = FluidUtil.tryFillContainer((ItemStack)bloodBottle, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true).getResult();
                    if (glass.m_41613_() > 1) {
                        glass.m_41774_(1);
                        playerIn.m_21008_(hand, glass);
                        playerIn.m_36356_(bloodBottle);
                    } else {
                        playerIn.m_21008_(hand, bloodBottle);
                    }
                }
            });
        }
        return InteractionResult.SUCCESS;
    }
}

