/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;

public class AltarCleansingBlock
extends VampirismHorizontalBlock {
    private static final String regName = "altar_cleansing";
    private static final VoxelShape SHAPEX = AltarCleansingBlock.makeShape();
    private static final VoxelShape SHAPEZ = UtilLib.rotateShape(SHAPEX, UtilLib.RotationAmount.NINETY);

    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)1.0, (double)12.0);
        VoxelShape b = Block.m_49796_((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)12.0, (double)11.0);
        VoxelShape c = Block.m_49796_((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)14.0, (double)13.0);
        VoxelShape r = Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
        return Shapes.m_83110_((VoxelShape)r, (VoxelShape)c);
    }

    public AltarCleansingBlock() {
        super(regName, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction dir = (Direction)blockState.m_61143_((Property)FACING);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            return SHAPEX;
        }
        return SHAPEZ;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Nonnull
    public String m_7705_() {
        return "block.vampirism.church_altar";
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!player.m_6084_()) {
            return InteractionResult.PASS;
        }
        LazyOptional<FactionPlayerHandler> handler = FactionPlayerHandler.getOpt(player);
        ItemStack heldItem = player.m_21120_(hand);
        if (handler.map(h -> h.isInFaction(VReference.VAMPIRE_FACTION)).orElse(false).booleanValue()) {
            if (world.m_5776_()) {
                VampirismMod.proxy.displayRevertBackScreen();
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_()) {
            if (((Object)((Object)ModItems.holy_salt_water)).equals(heldItem.m_41720_())) {
                if (world.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                boolean enhanced = handler.map(h -> h.isInFaction(VReference.HUNTER_FACTION) && h.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(s -> s.isSkillEnabled(HunterSkills.holy_water_enhanced)).orElse(false) != false).orElse(false);
                ItemStack newStack = new ItemStack((ItemLike)(enhanced ? ModItems.holy_water_bottle_enhanced : ModItems.holy_water_bottle_normal), heldItem.m_41613_());
                player.m_21008_(hand, newStack);
                return InteractionResult.SUCCESS;
            }
            if (((Object)((Object)ModItems.pure_salt)).equals(heldItem.m_41720_())) {
                if (world.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                player.m_21008_(hand, new ItemStack((ItemLike)ModItems.holy_salt, heldItem.m_41613_()));
            }
        }
        return InteractionResult.PASS;
    }
}

