/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blockentity.AlchemicalCauldronBlockEntity;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlchemicalCauldronBlock
extends AbstractFurnaceBlock {
    public static final String regName = "alchemical_cauldron";
    public static final IntegerProperty LIQUID = IntegerProperty.m_61631_((String)"liquid", (int)0, (int)2);
    protected static final VoxelShape cauldronShape = AlchemicalCauldronBlock.makeShape();

    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape b = Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape c = Block.m_49796_((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    public AlchemicalCauldronBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(4.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIQUID, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_48683_, (Comparable)Direction.NORTH)).m_61124_((Property)f_48684_, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("vampirism", regName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Random rng) {
        super.m_7100_(state, world, pos, rng);
        if ((Integer)state.m_61143_((Property)LIQUID) == 2) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, ModSounds.boiling, SoundSource.BLOCKS, 0.05f, 1.0f, false);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, @Nonnull BlockState p_153213_, @Nonnull BlockEntityType<T> p_153214_) {
        return p_153212_.m_5776_() ? null : AlchemicalCauldronBlock.m_152132_(p_153214_, ModTiles.alchemical_cauldron, AlchemicalCauldronBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new AlchemicalCauldronBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return cauldronShape;
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState, @Nonnull LivingEntity entity, @Nonnull ItemStack stack) {
        super.m_6402_(world, blockPos, blockState, entity, stack);
        BlockEntity tile = world.m_7702_(blockPos);
        if (entity instanceof Player && tile instanceof AlchemicalCauldronBlockEntity) {
            ((AlchemicalCauldronBlockEntity)tile).setOwnerID((Player)entity);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_48684_, f_48683_, LIQUID});
    }

    protected void m_7137_(Level world, @Nonnull BlockPos blockPos, @Nonnull Player playerEntity) {
        BlockEntity tile = world.m_7702_(blockPos);
        if (tile instanceof AlchemicalCauldronBlockEntity) {
            playerEntity.m_5893_((MenuProvider)tile);
            playerEntity.m_36220_(ModStats.interact_alchemical_cauldron);
        }
    }
}

