/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.world.FactionPointOfInterestType;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TotemHelper {
    public static final int MIN_HOMES = 4;
    public static final int MIN_WORKSTATIONS = 2;
    public static final int MIN_VILLAGER = 4;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Level>, Map<BlockPos, BlockPos>> totemPositions = Maps.newHashMap();
    private static final Map<ResourceKey<Level>, Map<BlockPos, Set<PoiRecord>>> poiSets = Maps.newHashMap();

    public static boolean addTotem(ServerLevel world, Set<PoiRecord> pois, BlockPos totemPos) {
        BlockPos conflict = null;
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), key -> new HashMap());
        for (PoiRecord poi2 : pois) {
            if (!totemPositions.containsKey(poi2.m_27257_()) || ((BlockPos)totemPositions.get(poi2.m_27257_())).equals((Object)totemPos)) continue;
            conflict = (BlockPos)totemPositions.get(poi2.m_27257_());
            break;
        }
        if (conflict != null) {
            TotemHelper.handleTotemConflict(pois, world, totemPos, conflict);
        }
        if (pois.isEmpty()) {
            return false;
        }
        for (PoiRecord pointOfInterest : pois) {
            totemPositions.put(pointOfInterest.m_27257_(), totemPos);
        }
        totemPositions.put(totemPos, totemPos);
        Map poiSets = TotemHelper.poiSets.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), key -> new HashMap());
        if (poiSets.containsKey(totemPos)) {
            ((Set)poiSets.get(totemPos)).forEach(poi -> {
                if (!pois.contains(poi)) {
                    totemPositions.remove(poi.m_27257_());
                }
            });
        }
        poiSets.put(totemPos, pois);
        return !pois.isEmpty();
    }

    private static void handleTotemConflict(Set<PoiRecord> pois, ServerLevel world, BlockPos totem, BlockPos conflicting) {
        boolean ignoreOtherTotem;
        TotemBlockEntity totem1 = (TotemBlockEntity)world.m_7702_(totem);
        TotemBlockEntity totem2 = (TotemBlockEntity)world.m_7702_(conflicting);
        if (totem2 == null) {
            return;
        }
        boolean bl = ignoreOtherTotem = totem1.getControllingFaction() == totem2.getControllingFaction();
        if (totem1.getCapturingFaction() != null || totem2.getCapturingFaction() != null) {
            ignoreOtherTotem = false;
        }
        StructureStart structure1 = UtilLib.getStructureStartAt(world, totem, StructureFeature.f_67028_);
        StructureStart structure2 = UtilLib.getStructureStartAt(world, conflicting, StructureFeature.f_67028_);
        if ((structure1 == StructureStart.f_73561_ || !structure1.m_73603_()) && structure2 != StructureStart.f_73561_ && structure2.m_73603_()) {
            ignoreOtherTotem = false;
        }
        if (totem2.getSize() >= totem1.getSize()) {
            ignoreOtherTotem = false;
        }
        if (!ignoreOtherTotem) {
            pois.removeIf(poi -> !totem.equals((Object)totemPositions.get(world.m_46472_()).get(poi.m_27257_())));
        }
    }

    public static void removeTotem(ResourceKey<Level> dimension, Collection<PoiRecord> pois, BlockPos pos, boolean removeTotem) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent(dimension, key -> new HashMap());
        pois.forEach(pointOfInterest -> totemPositions.remove(pointOfInterest.m_27257_(), pos));
        if (removeTotem) {
            totemPositions.remove(pos);
        }
    }

    @Nonnull
    public static Optional<BlockPos> getTotemPosition(ResourceKey<Level> dimension, Collection<PoiRecord> pois) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent(dimension, key -> new HashMap());
        for (PoiRecord pointOfInterest : pois) {
            if (!totemPositions.containsKey(pointOfInterest.m_27257_())) continue;
            return Optional.of((BlockPos)totemPositions.get(pointOfInterest.m_27257_()));
        }
        return Optional.empty();
    }

    @Nullable
    public static BlockPos getTotemPosition(ResourceKey<Level> world, BlockPos pos) {
        if (totemPositions.containsKey(world)) {
            return totemPositions.get(world).get(pos);
        }
        return null;
    }

    @Nonnull
    public static Optional<BlockPos> getTotemPosNearPos(ServerLevel world, BlockPos pos) {
        Collection points = world.m_8904_().m_27181_(p -> true, pos, 25, PoiManager.Occupancy.ANY).collect(Collectors.toList());
        if (!points.isEmpty()) {
            return TotemHelper.getTotemPosition((ResourceKey<Level>)world.m_46472_(), points);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<TotemBlockEntity> getTotemNearPos(ServerLevel world, BlockPos posSource, boolean mustBeLoaded) {
        Optional<BlockPos> posOpt = TotemHelper.getTotemPosNearPos(world, posSource);
        if (mustBeLoaded) {
            posOpt = posOpt.filter(arg_0 -> ((ServerLevel)world).m_143340_(arg_0));
        }
        return posOpt.map(pos -> {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof TotemBlockEntity) {
                return (TotemBlockEntity)tile;
            }
            return null;
        });
    }

    public static Component forceFactionCommand(IFaction<?> faction, ServerPlayer player) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent((ResourceKey<Level>)player.m_20193_().m_46472_(), key -> new HashMap());
        List pointOfInterests = ((ServerLevel)player.m_20193_()).m_8904_().m_27181_(point -> true, player.m_142538_(), 25, PoiManager.Occupancy.ANY).sorted(Comparator.comparingInt(point -> (int)point.m_27257_().m_123331_((Vec3i)player.m_142538_()))).collect(Collectors.toList());
        if (pointOfInterests.stream().noneMatch(point -> totemPositions.containsKey(point.m_27257_()))) {
            return new TranslatableComponent("command.vampirism.test.village.no_village");
        }
        BlockEntity te = player.m_20193_().m_7702_((BlockPos)totemPositions.get(((PoiRecord)pointOfInterests.get(0)).m_27257_()));
        if (!(te instanceof TotemBlockEntity)) {
            LOGGER.warn("TileEntity at {} is no TotemTileEntity", totemPositions.get(((PoiRecord)pointOfInterests.get(0)).m_27257_()));
            return new TextComponent("");
        }
        TotemBlockEntity tile = (TotemBlockEntity)te;
        tile.setForcedFaction(faction);
        return new TranslatableComponent("command.vampirism.test.village.success", new Object[]{faction == null ? "none" : faction.getName()});
    }

    public static Set<PoiRecord> getVillagePointsOfInterest(ServerLevel world, BlockPos pos) {
        PoiManager manager = world.m_8904_();
        HashSet finished = Sets.newHashSet();
        Set points = manager.m_27181_(type -> !(type instanceof FactionPointOfInterestType), pos, 50, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
        while (!points.isEmpty()) {
            List<Stream> list = points.stream().map(pointOfInterest -> manager.m_27181_(type -> !(type instanceof FactionPointOfInterestType), pointOfInterest.m_27257_(), 40, PoiManager.Occupancy.ANY)).collect(Collectors.toList());
            points.clear();
            list.forEach(stream -> stream.forEach(point -> {
                if (!finished.contains(point) && point.m_27257_().m_123314_((Vec3i)pos, (double)((Integer)VampirismConfig.BALANCE.viMaxTotemRadius.get()).intValue())) {
                    points.add(point);
                }
                finished.add(point);
            }));
        }
        return finished;
    }

    public static int isVillage(Map<Integer, Integer> stats, boolean hasInteraction) {
        int status = 0;
        if (stats.get(1) >= 4) {
            ++status;
        }
        if (stats.get(2) >= 2) {
            status += 2;
        }
        if (hasInteraction || stats.get(4) >= 4) {
            status += 4;
        }
        return status;
    }

    public static int isVillage(Set<PoiRecord> pointOfInterests, ServerLevel world, BlockPos totemPos, boolean hasInteraction) {
        if (UtilLib.getStructureStartAt(world, totemPos, StructureFeature.f_67028_) != StructureStart.f_73561_) {
            return 7;
        }
        return TotemHelper.isVillage(TotemHelper.getVillageStats(pointOfInterests, (Level)world), hasInteraction);
    }

    public static Map<Integer, Integer> getVillageStats(Set<PoiRecord> pointOfInterests, final Level world) {
        final Map poiTCounts = pointOfInterests.stream().map(PoiRecord::m_27258_).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        final AABB area = TotemHelper.getAABBAroundPOIs(pointOfInterests);
        return new HashMap<Integer, Integer>(){
            {
                this.put(1, poiTCounts.getOrDefault(PoiType.f_27346_, 0L).intValue());
                this.put(2, (int)poiTCounts.entrySet().stream().filter(entry -> entry.getKey() != PoiType.f_27346_).mapToLong(Map.Entry::getValue).sum());
                this.put(4, area == null ? 0 : world.m_45976_(Villager.class, area).size());
            }
        };
    }

    @Nullable
    public static AABB getAABBAroundPOIs(@Nonnull Set<PoiRecord> pois) {
        return pois.stream().map(poi -> new AABB(poi.m_27257_()).m_82400_(25.0)).reduce(AABB::m_82367_).orElse(null);
    }

    public static void ringBell(Level world, @Nonnull Player player) {
        if (!world.f_46443_) {
            Optional<TotemBlockEntity> tile = TotemHelper.getTotemNearPos((ServerLevel)world, player.m_142538_(), false);
            tile.ifPresent(s -> s.ringBell(player));
        }
    }
}

