/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.blocks.SieveBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SieveBlockEntity
extends BlockEntity
implements FluidTankWithListener.IFluidTankListener {
    private final LazyOptional<IFluidHandler> cap;
    private final FluidTankWithListener tank = new FilteringFluidTank(2000).setListener(this);
    private int cooldownPull = 0;
    private int cooldownProcess = 0;
    private boolean active;

    public SieveBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.sieve, pos, state);
        this.tank.setDrainable(false);
        this.cap = LazyOptional.of(() -> this.tank);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (facing != Direction.DOWN && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("active", this.isActive());
        return nbt;
    }

    public boolean isActive() {
        return this.active;
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag);
        this.cooldownProcess = tag.m_128451_("cooldown_process");
        this.cooldownPull = tag.m_128451_("cooldown_pull");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        boolean old = this.active;
        this.active = pkt.m_131708_().m_128471_("active");
        if (this.active != old && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.setActive(true, this.m_58900_());
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        this.tank.writeToNBT(compound);
        compound.m_128405_("cooldown_process", this.cooldownProcess);
        compound.m_128405_("cooldown_pull", this.cooldownPull);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SieveBlockEntity blockEntity) {
        if (--blockEntity.cooldownProcess < 0) {
            blockEntity.cooldownProcess = 15;
            if (blockEntity.tank.getFluidAmount() > 0) {
                FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP).ifPresent(handler -> {
                    blockEntity.tank.setDrainable(true);
                    FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)blockEntity.tank, (int)200, (boolean)true);
                    blockEntity.tank.setDrainable(false);
                    if (!transferred.isEmpty()) {
                        blockEntity.cooldownProcess = 30;
                        blockEntity.setActive(true, state);
                    }
                });
            } else if (blockEntity.active) {
                blockEntity.setActive(false, state);
            }
        }
        if (--blockEntity.cooldownPull < 0) {
            blockEntity.cooldownPull = 10;
            FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN).ifPresent(handler -> {
                FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)blockEntity.tank, (IFluidHandler)handler, (int)200, (boolean)true);
            });
        }
    }

    private void setActive(boolean active, BlockState blockState) {
        if (this.active != active) {
            this.active = active;
            if (this.f_58857_ != null && blockState.m_60734_() == ModBlocks.blood_sieve) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)SieveBlock.PROPERTY_ACTIVE, (Comparable)Boolean.valueOf(active)));
            }
        }
    }

    private class FilteringFluidTank
    extends FluidTankWithListener {
        private FilteringFluidTank(int capacity) {
            super(capacity);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!BloodConversionRegistry.existsBloodValue(resource.getFluid())) {
                return 0;
            }
            FluidStack converted = BloodConversionRegistry.getBloodFromFluid(resource);
            int filled = super.fill(converted, action);
            if (action.execute()) {
                SieveBlockEntity.this.cooldownPull = 10;
            }
            return (int)((float)filled / BloodConversionRegistry.getBloodValue(resource));
        }
    }
}

