/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.blocks.GarlicDiffuserBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GarlicDiffuserBlockEntity
extends BlockEntity {
    private static final int FUEL_DURATION = 2400;
    private int id;
    private EnumStrength strength = EnumStrength.MEDIUM;
    private EnumStrength defaultStrength = EnumStrength.MEDIUM;
    private int r = 1;
    private boolean registered = false;
    private int fueled = 0;
    private int bootTimer;
    private int maxBootTimer;
    private boolean initiateBootTimer = false;

    public GarlicDiffuserBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.garlic_diffuser, pos, state);
    }

    public float getBootProgress() {
        return this.bootTimer > 0 ? 1.0f - (float)this.bootTimer / (float)this.maxBootTimer : 1.0f;
    }

    public int getFuelTime() {
        return this.fueled;
    }

    public float getFueledState() {
        return (float)this.fueled / 2400.0f;
    }

    public void m_6339_() {
        super.m_6339_();
        if (this.isActive()) {
            this.register();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isActive() {
        return this.bootTimer == 0;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean isInRange(BlockPos pos) {
        return new ChunkPos(this.m_58899_()).m_45594_(new ChunkPos(pos)) <= this.r;
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.r = compound.m_128451_("radius");
        this.defaultStrength = EnumStrength.getFromStrength(compound.m_128451_("strength"));
        this.bootTimer = compound.m_128451_("boot_timer");
        this.setFueledTime(compound.m_128451_("fueled"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58898_()) {
            CompoundTag nbt = pkt.m_131708_();
            this.handleUpdateTag(nbt);
            if (this.isActive()) {
                this.register();
            }
        }
    }

    public void onTouched(Player player) {
        if (VampirismPlayerAttributes.get((Player)player).vampireLevel > 0) {
            VampirePlayer.getOpt(player).ifPresent(vampirePlayer -> DamageHandler.affectVampireGarlicDirect(vampirePlayer, this.strength));
        }
    }

    public void onFueled() {
        this.setFueledTime(2400);
        this.m_6596_();
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("radius", this.r);
        compound.m_128405_("strength", this.defaultStrength.getStrength());
        compound.m_128405_("fueled", this.fueled);
        if (this.bootTimer != 0) {
            compound.m_128405_("boot_timer", this.bootTimer);
        }
    }

    public void setNewBootDelay(int delayTicks) {
        this.bootTimer = delayTicks;
        this.maxBootTimer = delayTicks;
    }

    public void initiateBootTimer() {
        this.initiateBootTimer = true;
    }

    public void setType(GarlicDiffuserBlock.Type type) {
        switch (type) {
            case WEAK: {
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserWeakDist.get();
                this.defaultStrength = EnumStrength.WEAK;
                break;
            }
            case NORMAL: {
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserNormalDist.get();
                this.defaultStrength = EnumStrength.MEDIUM;
                break;
            }
            case IMPROVED: {
                this.defaultStrength = EnumStrength.MEDIUM;
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist.get();
            }
        }
        this.strength = this.defaultStrength;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.m_58898_()) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.unregister();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GarlicDiffuserBlockEntity blockEntity) {
        if (blockEntity.initiateBootTimer) {
            blockEntity.initiateBootTimer = false;
            int bootTime = (Integer)VampirismConfig.BALANCE.garlicDiffuserStartupTime.get() * 20;
            if (level instanceof ServerLevel && ((ServerLevel)level).m_6907_().size() <= 1) {
                bootTime >>= 2;
            }
            blockEntity.bootTimer = bootTime;
            blockEntity.maxBootTimer = bootTime;
        }
        if (blockEntity.bootTimer > 0) {
            if (--blockEntity.bootTimer == 0) {
                blockEntity.m_6596_();
                blockEntity.register();
            }
        } else if (blockEntity.fueled > 0) {
            if (blockEntity.fueled == 1) {
                blockEntity.setFueledTime(0);
                blockEntity.m_6596_();
            } else {
                --blockEntity.fueled;
            }
        }
    }

    private void register() {
        if (this.registered || !this.m_58898_()) {
            return;
        }
        int baseX = this.m_58899_().m_123341_() >> 4;
        int baseZ = this.m_58899_().m_123343_() >> 4;
        ChunkPos[] chunks = new ChunkPos[(2 * this.r + 1) * (2 * this.r + 1)];
        int i = 0;
        for (int x = -this.r; x <= this.r; ++x) {
            for (int z = -this.r; z <= this.r; ++z) {
                chunks[i++] = new ChunkPos(x + baseX, z + baseZ);
            }
        }
        this.id = VampirismAPI.getVampirismWorld(this.m_58904_()).map(vw -> vw.registerGarlicBlock(this.strength, chunks)).orElse(0);
        this.registered = i != 0;
    }

    private void setFueledTime(int time) {
        int old = this.fueled;
        this.fueled = time;
        this.strength = this.fueled > 0 ? EnumStrength.STRONG : this.defaultStrength;
        if ((time > 0 && old == 0 || time == 0 && old > 0) && !this.m_58901_()) {
            this.unregister();
            this.register();
        }
    }

    private void unregister() {
        if (this.registered && this.m_58898_()) {
            VampirismAPI.getVampirismWorld(this.m_58904_()).ifPresent(vw -> vw.removeGarlicBlock(this.id));
            this.registered = false;
        }
    }
}

