/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.blocks.AlchemicalCauldronBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.container.AlchemicalCauldronContainer;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.mixin.AbstractFurnaceBlockEntityAccessor;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlchemicalCauldronBlockEntity
extends AbstractFurnaceBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int[] SLOTS_DOWN = new int[]{0, 1, 2};
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_WEST = new int[]{1};
    private static final int[] SLOTS_FUEL = new int[]{3};
    @Nullable
    private UUID ownerID;
    @Nullable
    private String ownerName;
    private AlchemicalCauldronRecipe recipeChecked;
    private static boolean warnedRecipeType = false;

    public AlchemicalCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.alchemical_cauldron, pos, state, ModRecipes.ALCHEMICAL_CAULDRON_TYPE);
        this.f_58310_ = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    }

    public boolean m_7525_(@Nonnull Player player) {
        if (super.m_7525_(player)) {
            if (HunterPlayer.getOpt(player).map(HunterPlayer::getSkillHandler).map(h -> h.isSkillEnabled(HunterSkills.basic_alchemy)).orElse(false).booleanValue()) {
                if (this.ownerID == null) {
                    this.setOwnerID(player);
                    return true;
                }
                if (this.ownerID.equals(player.m_142081_())) {
                    return true;
                }
                player.m_6352_((Component)new TranslatableComponent("text.vampirism.alchemical_cauldron.other", new Object[]{this.getOwnerName()}), Util.f_137441_);
            } else {
                player.m_6352_((Component)new TranslatableComponent("text.vampirism.alchemical_cauldron.cannot_use", new Object[]{this.getOwnerName()}), Util.f_137441_);
            }
        }
        return false;
    }

    @Nonnull
    public Component m_7770_() {
        return new TranslatableComponent("tile.vampirism.alchemical_cauldron");
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent("tile.vampirism.alchemical_cauldron.display", new Object[]{this.ownerName, new TranslatableComponent("tile.vampirism.alchemical_cauldron")});
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getLiquidColorClient() {
        ItemStack liquidItem = (ItemStack)this.f_58310_.get(0);
        return FluidUtil.getFluidContained((ItemStack)liquidItem).map(fluidStack -> fluidStack.getFluid().getAttributes().getColor()).orElseGet(() -> ModRecipes.getLiquidColor(liquidItem.m_41720_()));
    }

    public Component getOwnerName() {
        return new TextComponent(this.ownerName == null ? "Unknown" : this.ownerName);
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : (side == Direction.WEST ? SLOTS_WEST : SLOTS_FUEL);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        if (this.ownerID != null) {
            compound.m_128362_("owner", this.ownerID);
        }
        if (this.ownerName != null) {
            compound.m_128359_("owner_name", this.ownerName);
        }
        ContainerHelper.m_18973_((CompoundTag)compound, (NonNullList)this.f_58310_);
        return compound;
    }

    public void handleUpdateTag(CompoundTag compound) {
        super.handleUpdateTag(compound);
        this.ownerID = compound.m_128403_("owner") ? compound.m_128342_("owner") : null;
        this.ownerName = compound.m_128441_("owner_name") ? compound.m_128461_("owner_name") : null;
        ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)this.f_58310_);
    }

    public void m_142466_(CompoundTag compound) {
        this.ownerID = compound.m_128403_("owner") ? compound.m_128342_("owner") : null;
        this.ownerName = compound.m_128441_("owner_name") ? compound.m_128461_("owner_name") : null;
        super.m_142466_(compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (this.m_58898_()) {
            this.handleUpdateTag(nbt);
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.ownerID != null) {
            compound.m_128362_("owner", this.ownerID);
        }
        if (this.ownerName != null) {
            compound.m_128359_("owner_name", this.ownerName);
        }
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            super.m_6596_();
            BlockState old = this.f_58857_.m_8055_(this.f_58858_);
            BlockState state = (BlockState)((BlockState)old.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.isBurning()))).m_61124_((Property)AlchemicalCauldronBlock.LIQUID, (Comparable)Integer.valueOf(((ItemStack)this.f_58310_.get(0)).m_41619_() ? 0 : (this.isBurning() ? 2 : 1)));
            if (old.equals(state)) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            } else {
                this.f_58857_.m_7731_(this.f_58858_, state, 3);
            }
        }
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        boolean flag;
        super.m_6836_(index, stack);
        ItemStack itemstack = (ItemStack)this.f_58310_.get(index);
        boolean bl = flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        if (flag) {
            this.m_6596_();
        }
    }

    public void setOwnerID(Player player) {
        this.ownerID = player.m_142081_();
        this.ownerName = player.m_7755_().getString();
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AlchemicalCauldronBlockEntity blockEntity) {
        boolean wasBurning = blockEntity.isBurning();
        boolean dirty = false;
        if (wasBurning) {
            blockEntity.f_58311_.m_8050_(0, blockEntity.f_58311_.m_6413_(0) - 1);
        }
        ItemStack itemstackFuel = (ItemStack)blockEntity.f_58310_.get(3);
        if (blockEntity.isBurning() || !itemstackFuel.m_41619_() && !((ItemStack)blockEntity.f_58310_.get(0)).m_41619_() && !((ItemStack)blockEntity.f_58310_.get(1)).m_41619_()) {
            AlchemicalCauldronRecipe cauldronRecipe = null;
            Optional irecipe = level.m_7465_().m_44015_(ModRecipes.ALCHEMICAL_CAULDRON_TYPE, (Container)blockEntity, level);
            if (irecipe.isPresent() && irecipe.get() instanceof AlchemicalCauldronRecipe) {
                cauldronRecipe = (AlchemicalCauldronRecipe)((Object)irecipe.get());
            } else if (!warnedRecipeType) {
                LOGGER.error("Got an unexpected/illegal recipe for recipe type {}. This might break the AlchemicalCauldron and is caused by another mod", ModRecipes.ALCHEMICAL_CAULDRON_TYPE);
                warnedRecipeType = true;
            }
            if (cauldronRecipe != null && !blockEntity.isBurning() && ((AbstractFurnaceBlockEntityAccessor)((Object)blockEntity)).canBurn_vampirism((Recipe<?>)cauldronRecipe, (NonNullList<ItemStack>)blockEntity.f_58310_, blockEntity.m_6893_()) && blockEntity.canPlayerCook(cauldronRecipe)) {
                blockEntity.f_58311_.m_8050_(0, blockEntity.m_7743_(itemstackFuel));
                blockEntity.f_58311_.m_8050_(1, blockEntity.f_58311_.m_6413_(0));
                if (blockEntity.isBurning()) {
                    dirty = true;
                    if (itemstackFuel.hasContainerItem()) {
                        blockEntity.f_58310_.set(3, (Object)itemstackFuel.getContainerItem());
                    } else if (!itemstackFuel.m_41619_()) {
                        Item item = itemstackFuel.m_41720_();
                        itemstackFuel.m_41774_(1);
                        if (itemstackFuel.m_41619_()) {
                            blockEntity.f_58310_.set(3, (Object)itemstackFuel.getContainerItem());
                        }
                    }
                }
            }
            if (cauldronRecipe != null && blockEntity.isBurning() && ((AbstractFurnaceBlockEntityAccessor)((Object)blockEntity)).canBurn_vampirism((Recipe<?>)cauldronRecipe, (NonNullList<ItemStack>)blockEntity.f_58310_, blockEntity.m_6893_()) && blockEntity.canPlayerCook(cauldronRecipe)) {
                blockEntity.f_58311_.m_8050_(2, blockEntity.f_58311_.m_6413_(2) + 1);
                if (blockEntity.f_58311_.m_6413_(2) == blockEntity.f_58311_.m_6413_(3)) {
                    blockEntity.f_58311_.m_8050_(2, 0);
                    blockEntity.f_58311_.m_8050_(3, AlchemicalCauldronBlockEntity.m_155009_((Level)level, ModRecipes.ALCHEMICAL_CAULDRON_TYPE, (Container)blockEntity));
                    blockEntity.finishCooking(cauldronRecipe);
                    dirty = true;
                }
            } else {
                blockEntity.f_58311_.m_8050_(2, 0);
            }
        } else if (!blockEntity.isBurning() && blockEntity.f_58311_.m_6413_(2) > 0) {
            blockEntity.f_58311_.m_8050_(2, Mth.m_14045_((int)(blockEntity.f_58311_.m_6413_(2) - 2), (int)0, (int)blockEntity.f_58311_.m_6413_(3)));
        }
        if (wasBurning != blockEntity.isBurning()) {
            dirty = true;
        }
        if (dirty) {
            blockEntity.m_6596_();
        }
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int id, @Nonnull Inventory player) {
        return new AlchemicalCauldronContainer(id, player, (Container)this, this.f_58311_, this.f_58857_ == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    @Nonnull
    protected Component m_6820_() {
        return new TranslatableComponent("tile.vampirism.alchemical_cauldron");
    }

    private boolean canPlayerCook(@Nonnull AlchemicalCauldronRecipe recipe) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.recipeChecked == recipe) {
            return true;
        }
        if (this.ownerID == null) {
            return false;
        }
        Player playerEntity = this.f_58857_.m_46003_(this.ownerID);
        if (playerEntity == null || !playerEntity.m_6084_()) {
            return false;
        }
        return HunterPlayer.getOpt(playerEntity).map(hunter -> {
            boolean canCook = recipe.canBeCooked(hunter.getLevel(), hunter.getSkillHandler());
            if (canCook) {
                this.recipeChecked = recipe;
                return true;
            }
            this.recipeChecked = null;
            return false;
        }).orElse(false);
    }

    private void finishCooking(AlchemicalCauldronRecipe recipe) {
        if (recipe != null && ((AbstractFurnaceBlockEntityAccessor)((Object)this)).canBurn_vampirism((Recipe<?>)recipe, (NonNullList<ItemStack>)this.f_58310_, this.m_6893_()) && this.canPlayerCook(recipe)) {
            ItemStack itemstackfluid = (ItemStack)this.f_58310_.get(0);
            ItemStack itemstackingredient = (ItemStack)this.f_58310_.get(1);
            ItemStack itemstack1result = recipe.m_8043_();
            ItemStack itemstackoutput = (ItemStack)this.f_58310_.get(2);
            if (itemstackoutput.m_41619_()) {
                this.f_58310_.set(2, (Object)itemstack1result.m_41777_());
            } else if (itemstackoutput.m_41720_() == itemstack1result.m_41720_()) {
                itemstackoutput.m_41769_(itemstack1result.m_41613_());
            }
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.m_6029_((Recipe)recipe);
            }
            Either<Ingredient, FluidStack> fluid = recipe.getFluid();
            fluid.ifLeft(ingredient -> itemstackfluid.m_41774_(1));
            fluid.ifRight(fluidStack -> this.f_58310_.set(0, (Object)FluidUtil.getFluidHandler((ItemStack)itemstackfluid).map(handler -> {
                FluidStack drained = handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (drained.getAmount() < fluidStack.getAmount()) {
                    handler.drain(new FluidStack(fluidStack.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return handler.getContainer();
            }).orElse(ItemStack.f_41583_)));
            itemstackingredient.m_41774_(1);
            this.recipeChecked = null;
        }
    }

    private boolean isBurning() {
        return this.f_58311_.m_6413_(0) > 0;
    }

    private boolean isCooking() {
        return this.f_58311_.m_6413_(2) > 0;
    }
}

