/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public interface IFactionLevelItem<T extends IFactionPlayer<T>>
extends IFactionExclusiveItem {
    @OnlyIn(value=Dist.CLIENT)
    default public void addFactionLevelToolTip(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        ChatFormatting factionC = ChatFormatting.DARK_RED;
        ChatFormatting levelC = ChatFormatting.DARK_RED;
        ChatFormatting skillC = ChatFormatting.DARK_RED;
        LazyOptional<IFactionPlayerHandler> playerHandler = player != null && player.m_6084_() ? VampirismAPI.getFactionPlayerHandler(player) : LazyOptional.empty();
        IFaction<?> usingFaction = this.getExclusiveFaction(stack);
        ISkill requiredSkill = this.getRequiredSkill(stack);
        int reqLevel = this.getMinLevel(stack);
        if (playerHandler.map(p -> p.isInFaction(usingFaction)).orElse(false).booleanValue()) {
            factionC = ChatFormatting.GREEN;
            if (playerHandler.map(IFactionPlayerHandler::getCurrentLevel).orElse(0) >= reqLevel) {
                levelC = ChatFormatting.GREEN;
            }
            if (playerHandler.map(IFactionPlayerHandler::getCurrentFactionPlayer).flatMap(a -> a.map(b -> b.getSkillHandler().isSkillEnabled(requiredSkill))).orElse(false).booleanValue()) {
                skillC = ChatFormatting.GREEN;
            }
        }
        if (usingFaction == null && this.getMinLevel(stack) == 0) {
            return;
        }
        MutableComponent string = new TextComponent("").m_7220_((Component)(usingFaction == null ? new TranslatableComponent("text.vampirism.all") : usingFaction.getNamePlural())).m_130940_(factionC);
        if (this.getMinLevel(stack) > 0) {
            string.m_7220_((Component)new TextComponent("@" + this.getMinLevel(stack)).m_130940_(levelC));
        }
        tooltip.add((Component)string);
        ISkill<T> reqSkill = this.getRequiredSkill(stack);
        if (reqSkill != null) {
            tooltip.add((Component)new TranslatableComponent("text.vampirism.required_skill", new Object[]{reqSkill.getName()}).m_130940_(skillC));
        }
    }

    public int getMinLevel(@Nonnull ItemStack var1);

    @Nullable
    public ISkill<T> getRequiredSkill(@Nonnull ItemStack var1);
}

