/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.world.ITotem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class VampirismVillageEvent
extends Event {
    protected final ITotem totem;

    public VampirismVillageEvent(ITotem totem) {
        this.totem = totem;
    }

    @Nullable
    public IFaction<?> getCapturingFaction() {
        return this.totem.getCapturingFaction();
    }

    @Nullable
    public IFaction<?> getControllingFaction() {
        return this.totem.getControllingFaction();
    }

    public ITotem getTotem() {
        return this.totem;
    }

    @Nonnull
    public AABB getVillageArea() {
        return this.totem.getVillageArea();
    }

    @Nonnull
    public AABB getVillageAreaReduced() {
        return this.totem.getVillageAreaReduced();
    }

    public Level getWorld() {
        return this.totem.getTileWorld();
    }

    public static class DefineRaidStrength
    extends VampirismVillageEvent {
        private final int badOmenLevel;
        private float defendStrength;
        private float attackStrength;

        public DefineRaidStrength(ITotem totem, int badOmenLevel, float defendStrength, float attackStrength) {
            super(totem);
            this.badOmenLevel = badOmenLevel;
            this.defendStrength = defendStrength;
            this.attackStrength = attackStrength;
        }

        public float getAttackStrength() {
            return this.attackStrength;
        }

        public void setAttackStrength(float attackStrength) {
            this.attackStrength = attackStrength;
        }

        public int getBadOmenLevel() {
            return this.badOmenLevel;
        }

        public float getDefendStrength() {
            return this.defendStrength;
        }

        public void setDefendStrength(float defendStrength) {
            this.defendStrength = defendStrength;
        }

        public boolean isBadOmenTriggered() {
            return this.badOmenLevel >= 0;
        }

        public boolean isPlayerRaid() {
            return this.badOmenLevel == -2;
        }

        public boolean isRandomRaid() {
            return this.badOmenLevel == -1;
        }
    }

    @Event.HasResult
    public static class InitiateCapture
    extends VampirismVillageEvent {
        @Nonnull
        private final IFaction<?> capturingFaction;
        private String message;

        public InitiateCapture(ITotem totem, @Nonnull IFaction<?> capturingFaction) {
            super(totem);
            this.capturingFaction = capturingFaction;
        }

        @Override
        @Nonnull
        public IFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    @Event.HasResult
    public static abstract class VillagerCaptureFinish
    extends VampirismVillageEvent {
        @Nonnull
        private final List<Villager> villager;
        private final boolean forced;

        public VillagerCaptureFinish(ITotem totem, @Nonnull List<Villager> villagerIn, boolean forced) {
            super(totem);
            this.villager = villagerIn;
            this.forced = forced;
        }

        @Nonnull
        public List<Villager> getVillager() {
            return this.villager;
        }

        public boolean isForced() {
            return this.forced;
        }

        public static class Pre
        extends VillagerCaptureFinish {
            public Pre(ITotem totem, @Nonnull List<Villager> villagerIn, boolean forced) {
                super(totem, villagerIn, forced);
            }
        }

        public static class Post
        extends VillagerCaptureFinish {
            public Post(ITotem totem, @Nonnull List<Villager> villagerIn, boolean forced) {
                super(totem, villagerIn, forced);
            }
        }
    }

    @Cancelable
    public static class MakeAggressive
    extends VampirismVillageEvent {
        private final Villager oldVillager;

        public MakeAggressive(ITotem totem, @Nonnull Villager villager) {
            super(totem);
            this.oldVillager = villager;
        }

        public Villager getOldVillager() {
            return this.oldVillager;
        }
    }

    @Event.HasResult
    public static class SpawnNewVillager
    extends VampirismVillageEvent {
        @Nullable
        private final Mob oldEntity;
        private final boolean replace;
        @Nonnull
        private Villager newVillager;
        @Deprecated
        private boolean willBeConverted;

        public SpawnNewVillager(ITotem totem, @Nullable Mob oldEntity, @Nonnull Villager newVillager, boolean replace, boolean willBeConverted) {
            super(totem);
            this.oldEntity = oldEntity;
            this.newVillager = newVillager;
            this.replace = replace;
            this.willBeConverted = willBeConverted;
        }

        public IFaction<?> getFaction() {
            return this.totem.getControllingFaction();
        }

        @Nonnull
        public Villager getNewVillager() {
            return this.newVillager;
        }

        public void setNewVillager(@Nonnull Villager newVillager) {
            this.newVillager = newVillager;
        }

        @Nullable
        public Mob getOldEntity() {
            return this.oldEntity;
        }

        public boolean isReplace() {
            return this.replace;
        }

        public boolean isWillBeConverted() {
            return this.willBeConverted;
        }

        public void setWillBeConverted(boolean willBeConverted) {
            this.willBeConverted = willBeConverted;
        }
    }
}

