/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DefaultAction<T extends IFactionPlayer<T>>
extends ForgeRegistryEntry<IAction<?>>
implements IAction<T> {
    private Component name;

    public void addEffectInstance(T player, MobEffectInstance instance) {
        ((EffectInstanceWithSource)instance).setSource(this.getRegistryName());
        player.getRepresentingPlayer().m_7292_(instance);
    }

    public boolean canBeUsedBy(T player) {
        return true;
    }

    @Override
    public IAction.PERM canUse(T player) {
        if (!this.isEnabled()) {
            return IAction.PERM.DISABLED;
        }
        if (this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            return this.canBeUsedBy(player) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
    }

    @Override
    public Component getName() {
        return this.name == null ? (this.name = new TranslatableComponent(this.getTranslationKey())) : this.name;
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return "action." + this.getRegistryName().m_135827_() + "." + this.getRegistryName().m_135815_();
    }

    public abstract boolean isEnabled();

    @Override
    public boolean onActivated(T player) {
        if (this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            return this.activate(player);
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
    }

    public void removePotionEffect(T player, MobEffect effect) {
        MobEffectInstance ins = player.getRepresentingPlayer().m_21124_(effect);
        while (ins != null) {
            EffectInstanceWithSource insM = (EffectInstanceWithSource)ins;
            if (insM.hasSource() && insM.getSource().equals((Object)this.getRegistryName())) {
                insM.removeEffect();
                break;
            }
            ins = insM.getHiddenEffect();
        }
    }

    public String toString() {
        return this.getRegistryName() + " (" + this.getClass().getSimpleName() + ")";
    }

    protected abstract boolean activate(T var1);
}

