/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.convertible;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;

public interface ICurableConvertedCreature<T extends PathfinderMob>
extends IConvertedCreature<T> {
    default public T createCuredEntity(PathfinderMob entity, EntityType<T> newType) {
        PathfinderMob newEntity = (PathfinderMob)newType.m_20615_(entity.f_19853_);
        if (!1.$assertionsDisabled && newEntity == null) {
            throw new AssertionError();
        }
        newEntity.m_20258_(entity.m_20240_(new CompoundTag()));
        newEntity.f_20883_ = entity.f_20883_;
        newEntity.f_20885_ = entity.f_20885_;
        newEntity.m_20084_(UUID.randomUUID());
        return (T)newEntity;
    }

    default public T cureEntity(ServerLevel world, PathfinderMob entity, EntityType<T> newType) {
        T newEntity = this.createCuredEntity(entity, newType);
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
        entity.f_19853_.m_7967_(newEntity);
        newEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!entity.m_20067_()) {
            world.m_5898_(null, 1027, entity.m_142538_(), 0);
        }
        VampirismAPI.getExtendedCreatureVampirism(newEntity).ifPresent(creature -> creature.setBlood(1));
        ForgeEventFactory.onLivingConvert((LivingEntity)entity, newEntity);
        return newEntity;
    }

    public EntityDataAccessor<Boolean> getConvertingDataParam();

    default public boolean handleSound(byte id, PathfinderMob entity) {
        if (id == 16) {
            if (!entity.m_20067_()) {
                entity.f_19853_.m_7785_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), SoundEvents.f_12644_, entity.m_5720_(), 1.0f + entity.m_21187_().nextFloat(), entity.m_21187_().nextFloat() * 0.7f + 0.3f, false);
            }
            return true;
        }
        return false;
    }

    default public InteractionResult interactWithCureItem(Player player, ItemStack stack, PathfinderMob entity) {
        if (!entity.m_21023_(MobEffects.f_19613_)) {
            return InteractionResult.CONSUME;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (!entity.f_19853_.f_46443_) {
            this.startConverting(player.m_142081_(), entity.m_21187_().nextInt(2400) + 2400, entity);
        }
        return InteractionResult.SUCCESS;
    }

    default public boolean isConverting(PathfinderMob entity) {
        return (Boolean)entity.m_20088_().m_135370_(this.getConvertingDataParam());
    }

    default public void registerConvertingData(@Nonnull PathfinderMob entity) {
        entity.m_20088_().m_135372_(this.getConvertingDataParam(), (Object)false);
    }

    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @Nonnull PathfinderMob entity) {
        entity.m_20088_().m_135381_(this.getConvertingDataParam(), (Object)true);
        entity.m_21195_(MobEffects.f_19613_);
        entity.f_19853_.m_7605_((Entity)entity, (byte)16);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

