/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterActionTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "hunter_action");
    private static final Logger LOGGER = LogManager.getLogger();

    public static Instance builder(Action action) {
        return new Instance(action);
    }

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, Action action) {
        this.m_66234_(player, instance -> instance.test(action));
    }

    @Nonnull
    protected Instance createInstance(JsonObject json, @Nonnull EntityPredicate.Composite entityPredicate, @Nonnull DeserializationContext conditionsParser) {
        Action action = Action.NONE;
        if (json.has("action")) {
            String name = json.get("action").getAsString();
            try {
                action = Action.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Action {} does not exist", (Object)name);
            }
        } else {
            LOGGER.warn("Action not specified");
        }
        return new Instance(action);
    }

    static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nonnull
        private final Action action;

        Instance(@Nonnull Action action) {
            super(ID, EntityPredicate.Composite.f_36667_);
            this.action = action;
        }

        @Nonnull
        public JsonObject m_7683_(@Nonnull SerializationContext serializer) {
            JsonObject json = super.m_7683_(serializer);
            json.addProperty("action", this.action.name());
            return json;
        }

        boolean test(Action action) {
            return this.action == action;
        }
    }

    public static enum Action {
        STAKE,
        NONE;

    }
}

