/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.proxy;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.UpdateEntityPacket;
import de.teamlapen.lib.proxy.CommonProxy;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.lib.util.SoundReference;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void handleCapability(Entity e, ResourceLocation key, CompoundTag data) {
        Capability cap = (Capability)HelperRegistry.getSyncableEntityCaps().get((Object)key);
        if (cap == null && e instanceof Player) {
            cap = (Capability)HelperRegistry.getSyncablePlayerCaps().get((Object)key);
        }
        if (cap == null) {
            LOGGER.warn("Capability with key {} is not registered in the HelperRegistry", (Object)key);
        } else {
            LazyOptional opt = e.getCapability(cap);
            opt.ifPresent(inst -> inst.loadUpdateFromNBT(data));
            if (!opt.isPresent()) {
                LOGGER.warn("Target entity {} does not have capability {}", (Object)e, (Object)cap);
            }
        }
    }

    @Override
    @Nonnull
    public ISoundReference createMasterSoundReference(SoundEvent event, float volume, float pinch) {
        return new SoundReference((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)volume, (float)pinch));
    }

    @Override
    @Nonnull
    public ISoundReference createSoundReference(SoundEvent event, SoundSource category, BlockPos pos, float volume, float pinch) {
        return new SoundReference((SoundInstance)new SimpleSoundInstance(event, category, volume, pinch, pos));
    }

    @Override
    @Nonnull
    public ISoundReference createSoundReference(SoundEvent event, SoundSource category, double x, double y, double z, float volume, float pinch) {
        return new SoundReference((SoundInstance)new SimpleSoundInstance(event, category, volume, pinch, (double)((float)x), (double)((float)y), (double)((float)z)));
    }

    @Override
    public String getActiveLanguage() {
        return Minecraft.m_91087_().m_91102_().m_118983_().toString();
    }

    @Override
    public Player getPlayerEntity(NetworkEvent.Context ctx) {
        return EffectiveSide.get() == LogicalSide.CLIENT ? Minecraft.m_91087_().f_91074_ : super.getPlayerEntity(ctx);
    }

    @Override
    public Level getWorldFromKey(ResourceKey<Level> world) {
        Level serverWorld = super.getWorldFromKey(world);
        if (serverWorld != null) {
            return serverWorld;
        }
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld != null && clientWorld.m_46472_().equals(world)) {
            return clientWorld;
        }
        return null;
    }

    @Override
    public void handleUpdateEntityPacket(UpdateEntityPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            LOGGER.error("Cannot handle update package because sending player entity is null. Message: {}", (Object)msg);
        } else {
            Entity e = player.m_20193_().m_6815_(msg.getId());
            if (e == null) {
                LOGGER.error("Did not find entity {}", (Object)msg.getId());
                if (msg.isPlayerItself()) {
                    LOGGER.error("Message is meant for player itself, but id mismatch {} {}. Loading anyway.", (Object)player.m_142049_(), (Object)msg.getId());
                    e = player;
                }
            }
            if (e != null) {
                if (msg.getData() != null) {
                    try {
                        ISyncable syncable = (ISyncable)e;
                        syncable.loadUpdateFromNBT(msg.getData());
                    }
                    catch (ClassCastException ex) {
                        LOGGER.warn("Target entity {} does not implement ISyncable ({})", (Object)e, (Object)ex);
                    }
                }
                if (msg.getCaps() != null) {
                    for (String key : msg.getCaps().m_128431_()) {
                        ClientProxy.handleCapability(e, new ResourceLocation(key), msg.getCaps().m_128469_(key));
                    }
                }
            }
        }
    }
}

