/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public abstract class InventoryContainer
extends AbstractContainerMenu {
    protected final ContainerLevelAccess worldPos;
    protected final Container inventory;
    private final int size;

    public InventoryContainer(MenuType<? extends InventoryContainer> containerType, int id, Inventory playerInventory, ContainerLevelAccess worldPos, @Nonnull Container inventory, SelectorInfo ... selectorInfos) {
        this(containerType, id, playerInventory, worldPos, inventory, SelectorSlot::new, selectorInfos);
    }

    public InventoryContainer(MenuType<? extends InventoryContainer> containerType, int id, Inventory playerInventory, ContainerLevelAccess worldPos, @Nonnull Container inventory, SelectorSlotFactory factory, SelectorInfo ... selectorInfos) {
        this(containerType, id, worldPos, inventory, selectorInfos.length);
        if (inventory.m_6643_() < selectorInfos.length) {
            throw new IllegalArgumentException("Inventory size smaller than selector infos");
        }
        inventory.m_5856_(playerInventory.f_35978_);
        for (int i = 0; i < selectorInfos.length; ++i) {
            SelectorSlot slot = factory.create(inventory, i, selectorInfos[i], arg_0 -> ((InventoryContainer)this).m_6199_(arg_0), this::isSlotEnabled);
            slot.setContainer(this);
            this.m_38897_(slot);
        }
    }

    private InventoryContainer(MenuType<? extends InventoryContainer> containerType, int id, ContainerLevelAccess worldPos, Container inventory, int size) {
        super(containerType, id);
        this.worldPos = worldPos;
        this.inventory = inventory;
        this.size = size;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerEntity, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            if (index < this.size) {
                if (!this.m_38903_(slotStack, this.size, 36 + this.size, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= this.size && index < 27 + this.size) {
                if (!this.m_38903_(slotStack, 0, this.size, false) && slotStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 27 + this.size, 36 + this.size, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 27 + this.size && index < 36 + this.size && !this.m_38903_(slotStack, 0, 27 + this.size, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerEntity, slotStack);
        }
        return result;
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_5785_(playerIn);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    protected void addPlayerSlots(Inventory playerInventory, int baseX, int baseY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, baseX + j * 18, baseY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, baseX + i * 18, baseY + 58));
        }
    }

    protected void addPlayerSlots(Inventory playerInventory) {
        this.addPlayerSlots(playerInventory, 8, 84);
    }

    protected boolean isSlotEnabled(int id) {
        return true;
    }

    @FunctionalInterface
    public static interface SelectorSlotFactory {
        public SelectorSlot create(Container var1, int var2, SelectorInfo var3, Consumer<Container> var4, Function<Integer, Boolean> var5);
    }

    public static class SelectorInfo {
        public final Predicate<ItemStack> predicate;
        public final int xDisplay;
        public final int yDisplay;
        public final int stackLimit;
        public final boolean inverted;
        @Nullable
        public final Pair<ResourceLocation, ResourceLocation> background;

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, boolean inverted, int limit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this.predicate = predicate;
            this.xDisplay = x;
            this.yDisplay = y;
            this.stackLimit = limit;
            this.inverted = inverted;
            this.background = background;
        }

        public SelectorInfo(Item item, int x, int y) {
            this(item, x, y, false, 64, null);
        }

        public SelectorInfo(Item item, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> item.equals(itemStack.m_41720_()), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(LazyOptional<Collection<Item>> lazyItemCollection, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> lazyItemCollection.map(list -> list.contains(itemStack.m_41720_())).orElse(false), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(TagKey<Item> tag, int x, int y) {
            this(tag, x, y, false, 64, null);
        }

        public SelectorInfo(TagKey<Item> tag, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> itemStack.m_204117_(tag), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y) {
            this(predicate, x, y, false);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, boolean inverted) {
            this(predicate, x, y, inverted, 64, null);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this(predicate, x, y, false, stackLimit, background);
        }

        public boolean validate(ItemStack s) {
            boolean result = this.predicate.test(s);
            return result != this.inverted;
        }
    }

    public static class SelectorSlot
    extends Slot {
        private final SelectorInfo info;
        private final Function<Integer, Boolean> activeFunc;
        private final Consumer<Container> refreshInvFunc;
        private InventoryContainer ourContainer;

        public SelectorSlot(Container inventoryIn, int index, SelectorInfo info, Consumer<Container> refreshInvFunc, Function<Integer, Boolean> activeFunc) {
            super(inventoryIn, index, info.xDisplay, info.yDisplay);
            this.info = info;
            this.activeFunc = activeFunc;
            this.refreshInvFunc = refreshInvFunc;
        }

        public InventoryContainer getContainer() {
            return this.ourContainer;
        }

        public void setContainer(InventoryContainer container) {
            this.ourContainer = container;
        }

        public int m_5866_(@Nonnull ItemStack stack) {
            return this.info.stackLimit;
        }

        public int m_6641_() {
            return this.info.stackLimit;
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return this.info.background;
        }

        public boolean m_6659_() {
            return this.activeFunc.apply(this.f_40219_);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return this.info.validate(stack);
        }

        public void m_40234_(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            super.m_40234_(oldStackIn, newStackIn);
            this.refreshInvFunc.accept(this.f_40218_);
        }
    }
}

