/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.config;

import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodValueLoader
extends SimplePreparableReloadListener<Collection<ResourceLocation>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BLOOD_VALUE_DIRECTORY = "vampirism_blood_values/";
    private final String folderLocation;
    private final String type;
    private final BiConsumer<Map<ResourceLocation, Integer>, Integer> consumer;
    @Nullable
    private final ResourceLocation multiplierName;
    private int multiplier;

    public BloodValueLoader(@Nonnull String nameIn, @Nonnull BiConsumer<Map<ResourceLocation, Integer>, Integer> consumerIn, @Nullable ResourceLocation multiplierNameIn) {
        this.folderLocation = BLOOD_VALUE_DIRECTORY + nameIn;
        this.consumer = consumerIn;
        this.multiplierName = multiplierNameIn;
        this.type = nameIn;
    }

    protected void apply(@Nonnull Collection<ResourceLocation> splashList, @Nonnull ResourceManager resourceManagerIn, @Nonnull ProfilerFiller profilerIn) {
        ConcurrentMap values = Maps.newConcurrentMap();
        for (ResourceLocation location : splashList) {
            String modId;
            Map<ResourceLocation, Integer> values_tmp = this.loadBloodValuesFromDataPack(location, modId = location.m_135815_().substring(this.folderLocation.length() + 1, location.m_135815_().length() - 4), resourceManagerIn);
            if (values_tmp == null) continue;
            values.putAll(values_tmp);
            LOGGER.debug(LogUtil.CONFIG, "Loaded {} {} blood values from {}", (Object)values_tmp.size(), (Object)this.type, (Object)modId);
        }
        LOGGER.info(LogUtil.CONFIG, "Loaded {} {} blood values", (Object)values.size(), (Object)this.type);
        this.consumer.accept(values, this.multiplier != 0 ? this.multiplier : 1);
    }

    @Nullable
    protected Map<ResourceLocation, Integer> loadBloodValuesFromDataPack(ResourceLocation location, String modId, ResourceManager resourceManager) {
        if (!ModList.get().isLoaded(modId)) {
            return null;
        }
        try {
            return this.loadBloodValuesFromReader(new InputStreamReader(resourceManager.m_142591_(location).m_6679_()), modId);
        }
        catch (IOException e) {
            LOGGER.error(LogUtil.CONFIG, "[ModCompat]Could not read default blood values for mod {}, this should not happen {}", (Object)modId, (Object)e);
            return null;
        }
    }

    protected <T> Map<ResourceLocation, Integer> loadBloodValuesFromReader(Reader r, String modId) throws IOException {
        ConcurrentMap bloodValues;
        block18: {
            bloodValues = Maps.newConcurrentMap();
            try {
                BufferedReader br = new BufferedReader(r);
                block12: while (true) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        int val;
                        if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                        String[] p = line.split("=");
                        if (p.length != 2) {
                            LOGGER.warn(LogUtil.CONFIG, "Line {}  in {} is not formatted properly", (Object)line, (Object)(modId + ".txt"));
                            continue;
                        }
                        if (p[0].equals(modId)) {
                            LOGGER.warn(LogUtil.CONFIG, "{} is not applicant for other the mod {} in {}", (Object)line, (Object)modId, (Object)(modId + ".txt"));
                        }
                        try {
                            val = Integer.parseInt(p[1]);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn(LogUtil.CONFIG, "Line {}  in {} is not formatted properly", (Object)line, (Object)(modId + ".txt"));
                            continue;
                        }
                        try {
                            ResourceLocation resourceLocation = new ResourceLocation(p[0]);
                            if (!resourceLocation.m_135827_().equals(modId)) {
                                LOGGER.warn(LogUtil.CONFIG, "Wrong namespace for entry {} in {}", (Object)p[0], (Object)(modId + ".txt"));
                                continue block12;
                            }
                            if (resourceLocation.equals((Object)this.multiplierName)) {
                                this.multiplier = val;
                                continue block12;
                            }
                            if (bloodValues.put(resourceLocation, val) == null) continue block12;
                            LOGGER.warn(LogUtil.CONFIG, "Duplicated entry for {} is being overridden in {}", (Object)(modId + ".txt"), (Object)p[0]);
                            continue block12;
                        }
                        catch (ResourceLocationException e) {
                            LOGGER.error(LogUtil.CONFIG, "Id is not valid in file " + modId + ".txt: " + line, (Throwable)e);
                        }
                    }
                    break block18;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    br.close();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Failed to load blood values from reader " + modId, (Throwable)e);
            }
        }
        return bloodValues;
    }

    @Nonnull
    protected Collection<ResourceLocation> prepare(ResourceManager resourceManagerIn, @Nonnull ProfilerFiller profilerIn) {
        return resourceManagerIn.m_6540_(this.folderLocation, file -> file.endsWith(".txt"));
    }
}

