/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.GuiUtils;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class ScrollableListWidget<T>
extends ExtendedButton {
    private static final ResourceLocation MISC = new ResourceLocation("teamlapenlib", "textures/gui/misc.png");
    protected final List<ListItem<T>> listItems = new ArrayList<ListItem<T>>();
    private final ItemCreator<T> itemSupplier;
    private final int itemHeight;
    private final int scrollerWidth = 9;
    private final Supplier<Collection<T>> baseValueSupplier;
    private int scrolled;
    private double scrolledD;
    private boolean scrollerClicked;
    private boolean canScroll = true;
    private double scrollSpeed = 1.0;

    public ScrollableListWidget(int xPos, int yPos, int width, int height, int itemHeight, @Nonnull Supplier<Collection<T>> baseValueSupplier, @Nonnull ItemCreator<T> itemSupplier) {
        super(xPos, yPos, width, height, (Component)new TextComponent(""), button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
        this.baseValueSupplier = baseValueSupplier;
        this.refresh();
    }

    public ScrollableListWidget(int xPos, int yPos, int width, int height, int itemHeight, @Nonnull Supplier<Collection<T>> baseValueSupplier, @Nonnull ItemCreator<T> itemSupplier, Component name) {
        super(xPos, yPos, width, height, name, button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
        this.baseValueSupplier = baseValueSupplier;
        this.refresh();
    }

    public void addItem(@Nonnull T element) {
        this.listItems.add(this.itemSupplier.apply(element, this));
        this.setCanScroll();
    }

    public boolean isEmpty() {
        return this.listItems.isEmpty();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_) {
            return false;
        }
        this.scrolledD = this.scrolled;
        if (mouseX > (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY > (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_)) {
            if (mouseX > (double)(this.f_93620_ + this.f_93618_ - this.scrollerWidth)) {
                this.scrollerClicked = true;
            } else {
                for (int i = 0; i < this.listItems.size(); ++i) {
                    int y = i * this.itemHeight - this.scrolled;
                    if (y < -this.itemHeight) continue;
                    ListItem<T> item = this.listItems.get(i);
                    if (!(mouseX > (double)(this.f_93620_ + 1)) || !(mouseX < (double)(this.f_93620_ + this.f_93618_ - this.scrollerWidth)) || !(mouseY > (double)(this.f_93621_ + 1 + y)) || !(mouseY < (double)(this.f_93621_ + 1 + y + this.itemHeight)) || !item.onClick(mouseX, mouseY)) continue;
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.f_93624_ && this.canScroll && this.scrollerClicked) {
            double perc = dragY / (double)(this.f_93619_ - 27);
            double s = (double)(this.listItems.size() * this.itemHeight - this.f_93619_) * perc;
            this.scrolledD += s;
            this.scrolled = (int)this.scrolledD;
            this.scrolled = Mth.m_14045_((int)this.scrolled, (int)0, (int)(this.listItems.size() * this.itemHeight - this.f_93619_ + 2));
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollerClicked = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        if (this.canScroll) {
            this.scrolled = Mth.m_14045_((int)(this.scrolled + 4 * (int)(-(delta * this.scrollSpeed))), (int)0, (int)(this.listItems.size() * this.itemHeight - this.f_93619_ + 2));
            this.scrolledD = this.scrolled;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.setItems(this.baseValueSupplier.get());
    }

    public void removeItem(T element) {
        this.listItems.removeIf(item -> item.item == element);
        this.setCanScroll();
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        matrixStack.m_85836_();
        RenderSystem.m_69482_();
        matrixStack.m_85837_(0.0, 0.0, 950.0);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListWidget.m_93172_((PoseStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69456_((int)518);
        matrixStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        ScrollableListWidget.m_93172_((PoseStack)matrixStack, (int)this.f_93618_, (int)this.f_93619_, (int)0, (int)0, (int)-16711680);
        matrixStack.m_85837_((double)(-this.f_93620_), (double)(-this.f_93621_), 0.0);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.renderItems(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)518);
        matrixStack.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListWidget.m_93172_((PoseStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.m_85837_(0.0, 0.0, 950.0);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        matrixStack.m_85849_();
        this.m_7428_(matrixStack, mouseX, mouseY);
    }

    public void m_7428_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
        if (mouseX > this.f_93620_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY > this.f_93621_ && mouseY < this.f_93621_ + this.f_93619_ + 1) {
            int itemHeight = this.itemHeight;
            for (int i = 0; i < this.listItems.size(); ++i) {
                int y = i * itemHeight - this.scrolled;
                if (y < -itemHeight) continue;
                ListItem<T> item = this.listItems.get(i);
                item.preRenderToolTip(matrixStack, this.f_93620_, this.f_93621_ + y + 1, this.f_93618_ - 9, this.f_93619_, this.itemHeight, mouseX, mouseY, this.m_93252_());
            }
        }
    }

    public ScrollableListWidget<T> scrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
        return this;
    }

    public void setItems(@Nonnull Collection<T> elements) {
        this.listItems.clear();
        elements.forEach(item -> this.listItems.add(this.itemSupplier.apply(item, this)));
        this.setScrolled(0);
        this.setCanScroll();
    }

    protected void addItem(@Nonnull ListItem<T> newElement, @Nonnull ListItem<T> afterElement) {
        this.listItems.add(this.listItems.indexOf(afterElement) + 1, newElement);
        this.setCanScroll();
    }

    protected void removeItem(ListItem<T> item) {
        this.listItems.remove(item);
        this.setCanScroll();
    }

    private void renderBackground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)new ResourceLocation("textures/gui/widgets.png"), (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)46, (int)(this.f_93618_ - this.scrollerWidth + 1), (int)this.f_93619_, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)this.m_93252_());
    }

    private void renderItems(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int itemHeight = this.itemHeight;
        for (int i = 0; i < this.listItems.size(); ++i) {
            int y = i * itemHeight - this.scrolled;
            ListItem<T> item = this.listItems.get(i);
            item.render(matrixStack, this.f_93620_ + 1, this.f_93621_ + 1 + y, this.f_93618_ - 9 - 1, this.f_93619_, this.itemHeight, mouseX, mouseY, partialTicks, this.m_93252_());
        }
        this.renderScrollBar(matrixStack, mouseX, mouseY, partialTicks);
        this.m_93154_(matrixStack, this.f_93620_, this.f_93620_ + this.f_93618_ - 1, this.f_93621_, -16777216);
        this.m_93154_(matrixStack, this.f_93620_, this.f_93620_ + this.f_93618_ - 1, this.f_93621_ + this.f_93619_ - 1, -16777216);
    }

    private void renderScrollBar(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)MISC, (int)(this.f_93620_ + this.f_93618_ - this.scrollerWidth), (int)this.f_93621_, (int)0, (int)0, (int)9, (int)this.f_93619_, (int)9, (int)200, (int)2, (float)this.m_93252_());
        this.renderScroller(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScroller(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int scrollerHeight = 27;
        int scrollHeight = this.f_93619_ - 2 - scrollerHeight;
        float perc = (float)this.scrolled / (float)(this.listItems.size() * this.itemHeight - this.f_93619_ + 2);
        int yOffset = (int)((float)scrollHeight * perc);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        int yMaxSize = Mth.m_14045_((int)(this.itemHeight * this.listItems.size() - 2), (int)0, (int)27);
        this.m_93228_(matrixStack, this.f_93620_ + this.f_93618_ - this.scrollerWidth + 1, this.f_93621_ + yOffset + 1, this.canScroll ? 9 : 16, 0, 7, yMaxSize);
    }

    private void setCanScroll() {
        this.canScroll = this.listItems.size() * this.itemHeight > this.f_93619_;
    }

    private void setScrolled(int scrolled) {
        this.scrolled = scrolled;
        this.scrolledD = this.scrolled;
    }

    @FunctionalInterface
    public static interface ItemCreator<T> {
        public ListItem<T> apply(@Nonnull T var1, @Nonnull ScrollableListWidget<T> var2);
    }

    public static abstract class ListItem<T> {
        private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        @Nonnull
        protected final T item;
        @Nonnull
        protected final ScrollableListWidget<T> list;

        public ListItem(@Nonnull T item, @Nonnull ScrollableListWidget<T> list) {
            this.item = item;
            this.list = list;
        }

        public boolean onClick(double mouseX, double mouseY) {
            return false;
        }

        public void preRenderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
            int ySize = Mth.m_14045_((int)listHeight, (int)0, (int)itemHeight);
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + ySize) {
                this.renderToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            }
        }

        public void render(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            int v = 66;
            if (mouseX >= x && mouseX < x + listWidth && mouseY >= y && mouseY < y + itemHeight) {
                v = 86;
            }
            RenderSystem.m_69482_();
            GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)WIDGETS, (int)x, (int)y, (int)0, (int)v, (int)(listWidth + 1), (int)itemHeight, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)zLevel);
            RenderSystem.m_69465_();
        }

        public void renderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
        }
    }
}

