/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.MouseUtil;
import mezz.jei.common.input.UserInput;
import net.minecraftforge.client.event.ScreenEvent;

public final class ForgeUserInput {
    private ForgeUserInput() {
    }

    public static UserInput fromEvent(ScreenEvent.KeyboardKeyEvent keyEvent) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyEvent.getKeyCode(), (int)keyEvent.getScanCode());
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        int modifiers = keyEvent.getModifiers();
        return new UserInput(input, mouseX, mouseY, modifiers, InputType.IMMEDIATE);
    }

    public static Optional<UserInput> fromEvent(ScreenEvent.MouseClickedEvent event) {
        int button = event.getButton();
        if (button < 0) {
            return Optional.empty();
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(button);
        UserInput userInput = new UserInput(input, event.getMouseX(), event.getMouseY(), 0, InputType.SIMULATE);
        return Optional.of(userInput);
    }

    public static Optional<UserInput> fromEvent(ScreenEvent.MouseReleasedEvent event) {
        int button = event.getButton();
        if (button < 0) {
            return Optional.empty();
        }
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(button);
        UserInput userInput = new UserInput(input, event.getMouseX(), event.getMouseY(), 0, InputType.EXECUTE);
        return Optional.of(userInput);
    }
}

