/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.InputConstants;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.KeyPressPKT;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ClientKeyHelper {
    private static ImmutableBiMap<KeyMapping, PEKeybind> mcToPe = ImmutableBiMap.of();
    private static ImmutableBiMap<PEKeybind, KeyMapping> peToMc = ImmutableBiMap.of();

    @SubscribeEvent
    public static void keyPress(TickEvent.ClientTickEvent event) {
        for (KeyMapping k : mcToPe.keySet()) {
            while (k.m_90859_()) {
                PacketHandler.sendToServer(new KeyPressPKT((PEKeybind)mcToPe.get((Object)k)));
            }
        }
    }

    public static void registerKeyBindings() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyMapping, PEKeybind>)builder, PEKeybind.HELMET_TOGGLE, KeyModifier.SHIFT, 88);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyMapping, PEKeybind>)builder, PEKeybind.BOOTS_TOGGLE, KeyModifier.NONE, 88);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyMapping, PEKeybind>)builder, PEKeybind.CHARGE, KeyModifier.NONE, 86);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyMapping, PEKeybind>)builder, PEKeybind.EXTRA_FUNCTION, KeyModifier.NONE, 67);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyMapping, PEKeybind>)builder, PEKeybind.FIRE_PROJECTILE, KeyModifier.NONE, 82);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyMapping, PEKeybind>)builder, PEKeybind.MODE, KeyModifier.NONE, 71);
        mcToPe = builder.build();
        peToMc = mcToPe.inverse();
        for (KeyMapping k : mcToPe.keySet()) {
            ClientRegistry.registerKeyBinding((KeyMapping)k);
        }
    }

    private static void addKeyBinding(ImmutableBiMap.Builder<KeyMapping, PEKeybind> builder, PEKeybind keyBind, KeyModifier modifier, int keyCode) {
        builder.put((Object)new KeyMapping(keyBind.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, modifier, InputConstants.Type.KEYSYM, keyCode, PELang.PROJECTE.getTranslationKey()), (Object)keyBind);
    }

    public static Component getKeyName(PEKeybind k) {
        if (peToMc.containsKey((Object)k)) {
            return ((KeyMapping)peToMc.get((Object)k)).m_90863_();
        }
        return TextComponentUtil.build(k);
    }
}

