/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ToolHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PEKatar
extends PETool
implements IItemMode,
IExtraFunction {
    private final ToolHelper.ChargeAttributeCache attributeCache = new ToolHelper.ChargeAttributeCache();
    private final ILangEntry[] modeDesc = new ILangEntry[]{PELang.MODE_KATAR_1, PELang.MODE_KATAR_2};

    public PEKatar(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, PETags.Blocks.MINEABLE_WITH_PE_KATAR, 19.0f, -2.4f, numCharges, props);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return this.modeDesc;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add(this.getToolTip(stack));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHEARS_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction) || ToolHelper.DEFAULT_PE_KATAR_ACTIONS.contains(toolAction);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        int charge = this.getCharge(stack);
        return target.m_142469_().m_82377_((double)charge, (double)charge / 4.0, (double)charge);
    }

    @Override
    protected float getShortCutDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        Material material;
        float destroySpeed = super.getShortCutDestroySpeed(stack, state);
        if (destroySpeed == 1.0f && ((material = state.m_60767_()) == Material.f_76300_ || material == Material.f_76302_ || state.m_204336_(BlockTags.f_13035_) || material == Material.f_76285_)) {
            return 1.5f;
        }
        return destroySpeed;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        return ToolHelper.performActions(ToolHelper.stripLogsAOE(context, state, 0L), () -> ToolHelper.scrapeAOE(context, state, 0L), () -> ToolHelper.waxOffAOE(context, state, 0L), () -> ToolHelper.tillAOE(context, state, 0L), () -> {
            if (state.m_204336_(BlockTags.f_13106_)) {
                return ToolHelper.clearTagAOE(level, player, context.m_43724_(), context.m_43722_(), 0L, (TagKey<Block>)BlockTags.f_13106_);
            }
            return InteractionResult.PASS;
        }, () -> {
            if (state.m_204336_(BlockTags.f_13035_)) {
                return ToolHelper.clearTagAOE(level, player, context.m_43724_(), context.m_43722_(), 0L, (TagKey<Block>)BlockTags.f_13035_);
            }
            return InteractionResult.PASS;
        });
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity damaged, @NotNull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return ToolHelper.shearBlock(stack, pos, player).m_19077_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        return ItemHelper.actionResultFromType(ToolHelper.shearEntityAOE(player, hand, 0L), player.m_21120_(hand));
    }

    @Override
    public boolean doExtraFunction(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand) {
        if (player.m_36403_(0.0f) == 1.0f) {
            ToolHelper.attackAOE(stack, player, this.getMode(stack) == 1, ProjectEConfig.server.difficulty.katarDeathAura.get(), 0L, hand);
            PlayerHelper.resetCooldown(player);
            return true;
        }
        return false;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, ItemStack stack) {
        return this.attributeCache.addChargeAttributeModifier((Multimap<Attribute, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        BlockPos pos;
        IForgeShearable target;
        if (entity instanceof IForgeShearable && (target = (IForgeShearable)entity).isShearable(stack, entity.f_19853_, pos = entity.m_142538_())) {
            if (!entity.f_19853_.f_46443_) {
                List drops = target.onSheared(player, stack, entity.f_19853_, pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    if (ent != null) {
                        ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

