/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Function;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NSSFluid
extends AbstractNBTNSSTag<Fluid> {
    private NSSFluid(@NotNull ResourceLocation resourceLocation, boolean isTag, @Nullable CompoundTag nbt) {
        super(resourceLocation, isTag, nbt);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull FluidStack stack) {
        return NSSFluid.createFluid(stack.getFluid(), stack.getTag());
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull Fluid fluid) {
        return NSSFluid.createFluid(fluid, null);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull Fluid fluid, @Nullable CompoundTag nbt) {
        if (fluid == Fluids.f_76191_) {
            throw new IllegalArgumentException("Can't make NSSFluid with an empty fluid");
        }
        return NSSFluid.createFluid(fluid.getRegistryName(), nbt);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull ResourceLocation fluidID) {
        return NSSFluid.createFluid(fluidID, null);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull ResourceLocation fluidID, @Nullable CompoundTag nbt) {
        return new NSSFluid(fluidID, false, nbt);
    }

    @NotNull
    public static NSSFluid createTag(@NotNull ResourceLocation tagId) {
        return new NSSFluid(tagId, true, null);
    }

    @NotNull
    public static NSSFluid createTag(@NotNull TagKey<Fluid> tag) {
        return NSSFluid.createTag(tag.f_203868_());
    }

    @Override
    protected boolean isInstance(AbstractNSSTag<?> o) {
        return o instanceof NSSFluid;
    }

    @Override
    @NotNull
    public String getJsonPrefix() {
        return "FLUID|";
    }

    @Override
    @NotNull
    public String getType() {
        return "Fluid";
    }

    @Override
    @NotNull
    protected Optional<Either<HolderSet.Named<Fluid>, ITag<Fluid>>> getTag() {
        return this.getTag(ForgeRegistries.FLUIDS);
    }

    @Override
    protected Function<Fluid, NormalizedSimpleStack> createNew() {
        return NSSFluid::createFluid;
    }
}

