/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CustomConversionProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, CustomConversionBuilder> customConversions = new LinkedHashMap<ResourceLocation, CustomConversionBuilder>();
    private final DataGenerator generator;

    protected CustomConversionProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public final void m_6865_(HashCache cache) {
        this.customConversions.clear();
        this.addCustomConversions();
        for (Map.Entry<ResourceLocation, CustomConversionBuilder> entry : this.customConversions.entrySet()) {
            ResourceLocation customConversion = entry.getKey();
            Path path = this.generator.m_123916_().resolve("data/" + customConversion.m_135827_() + "/pe_custom_conversions/" + customConversion.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)entry.getValue().serialize(), (Path)path);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't save custom conversion file for conversion: " + customConversion, e);
            }
        }
    }

    protected abstract void addCustomConversions();

    protected CustomConversionBuilder createConversionBuilder(ResourceLocation id) {
        Objects.requireNonNull(id, "Custom Conversion Builder ID cannot be null.");
        if (this.customConversions.containsKey(id)) {
            throw new RuntimeException("Custom conversion '" + id + "' has already been registered.");
        }
        CustomConversionBuilder conversionBuilder = new CustomConversionBuilder(id);
        this.customConversions.put(id, conversionBuilder);
        return conversionBuilder;
    }

    public String m_6055_() {
        return "Custom EMC Conversions";
    }
}

