/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.config.CustomEMCParser;
import moze_intel.projecte.config.PEModConfig;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.json.NSSSerializer;
import moze_intel.projecte.emc.mappers.recipe.CraftingMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.customRecipes.FullKleinStarIngredient;
import moze_intel.projecte.gameObjs.customRecipes.FullKleinStarsCondition;
import moze_intel.projecte.gameObjs.customRecipes.TomeEnabledCondition;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.rings.Arcana;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.handlers.CommonInternalAbilities;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.IMCHandler;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.ThreadCheckUUID;
import moze_intel.projecte.network.ThreadCheckUpdate;
import moze_intel.projecte.network.commands.ClearKnowledgeCMD;
import moze_intel.projecte.network.commands.DumpMissingEmc;
import moze_intel.projecte.network.commands.RemoveEmcCMD;
import moze_intel.projecte.network.commands.ResetEmcCMD;
import moze_intel.projecte.network.commands.SetEmcCMD;
import moze_intel.projecte.network.commands.ShowBagCMD;
import moze_intel.projecte.network.commands.argument.ColorArgument;
import moze_intel.projecte.network.commands.argument.NSSItemArgument;
import moze_intel.projecte.network.commands.argument.UUIDArgument;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="projecte")
@Mod.EventBusSubscriber(modid="projecte")
public class PECore {
    public static final String MODID = "projecte";
    public static final String MODNAME = "ProjectE";
    public static final GameProfile FAKEPLAYER_GAMEPROFILE = new GameProfile(UUID.fromString("590e39c7-9fb6-471b-a4c2-c0e539b2423d"), "[ProjectE]");
    public static final Logger LOGGER = LogManager.getLogger((String)"projecte");
    public static final List<String> uuids = new ArrayList<String>();
    public static ModContainer MOD_CONTAINER;
    @Nullable
    private EmcUpdateData emcUpdateResourceManager;

    public static void debugLog(String msg, Object ... args) {
        if (!FMLEnvironment.production || ProjectEConfig.common.debugLogging.get()) {
            LOGGER.info(msg, args);
        } else {
            LOGGER.debug(msg, args);
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public PECore() {
        MOD_CONTAINER = ModLoadingContext.get().getActiveContainer();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::imcQueue);
        modEventBus.addListener(this::imcHandle);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addGenericListener(RecipeSerializer.class, this::registerRecipeSerializers);
        PEBlocks.BLOCKS.register(modEventBus);
        PEContainerTypes.CONTAINER_TYPES.register(modEventBus);
        PEEntityTypes.ENTITY_TYPES.register(modEventBus);
        PEItems.ITEMS.register(modEventBus);
        PERecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        PESoundEvents.SOUND_EVENTS.register(modEventBus);
        PEBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(this::tagsUpdated);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverQuit);
        ProjectEConfig.register();
    }

    private void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        CraftingHelper.register(TomeEnabledCondition.SERIALIZER);
        CraftingHelper.register(FullKleinStarsCondition.SERIALIZER);
        CraftingHelper.register((ResourceLocation)PECore.rl("full_klein_star"), FullKleinStarIngredient.SERIALIZER);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IAlchBagProvider.class);
        event.register(IKnowledgeProvider.class);
        event.register(InternalTimers.class);
        event.register(InternalAbilities.class);
        event.register(CommonInternalAbilities.class);
        event.register(IAlchBagItem.class);
        event.register(IAlchChestItem.class);
        event.register(IExtraFunction.class);
        event.register(IItemCharge.class);
        event.register(IItemEmcHolder.class);
        event.register(IModeChanger.class);
        event.register(IPedestalItem.class);
        event.register(IProjectileShooter.class);
        event.register(IEmcStorage.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new ThreadCheckUpdate().start();
        EMCMappingHandler.loadMappers();
        CraftingMapper.loadMappers();
        NBTManager.loadProcessors();
        event.enqueueWork(() -> {
            PETags.init();
            PacketHandler.register();
            PECore.registerDispenseBehavior((DispenseItemBehavior)new ShearsDispenseItemBehavior(), PEItems.DARK_MATTER_SHEARS, PEItems.RED_MATTER_SHEARS, PEItems.RED_MATTER_KATAR);
            DispenserBlock.m_52672_(PEBlocks.NOVA_CATALYST, (DispenseItemBehavior)PEBlocks.NOVA_CATALYST.getBlock().createDispenseItemBehavior());
            DispenserBlock.m_52672_(PEBlocks.NOVA_CATACLYSM, (DispenseItemBehavior)PEBlocks.NOVA_CATACLYSM.getBlock().createDispenseItemBehavior());
            PECore.registerDispenseBehavior((DispenseItemBehavior)new OptionalDispenseItemBehavior(){

                @NotNull
                protected ItemStack m_7498_(@NotNull BlockSource source, @NotNull ItemStack stack) {
                    Arcana item;
                    Item item2 = stack.m_41720_();
                    if (item2 instanceof Arcana && (item = (Arcana)item2).getMode(stack) != 1) {
                        this.m_123573_(false);
                        return super.m_7498_(source, stack);
                    }
                    ServerLevel level = source.m_7727_();
                    this.m_123573_(true);
                    Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                    BlockPos pos = source.m_7961_().m_142300_(direction);
                    BlockState state = level.m_8055_(pos);
                    if (BaseFireBlock.m_49255_((Level)level, (BlockPos)pos, (Direction)direction)) {
                        level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                    } else if (CampfireBlock.m_51321_((BlockState)state)) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                    } else if (state.isFlammable((BlockGetter)level, pos, direction.m_122424_())) {
                        state.onCaughtFire((Level)level, pos, direction.m_122424_(), null);
                        if (state.m_60734_() instanceof TntBlock) {
                            level.m_7471_(pos, false);
                        }
                    } else {
                        this.m_123573_(false);
                    }
                    return stack;
                }
            }, PEItems.IGNITION_RING, PEItems.ARCANA_RING);
            DispenserBlock.m_52672_(PEItems.EVERTIDE_AMULET, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

                @NotNull
                public ItemStack m_7498_(@NotNull BlockSource source, @NotNull ItemStack stack) {
                    Optional capability;
                    ServerLevel level = source.m_7727_();
                    Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                    BlockPos pos = source.m_7961_().m_142300_(direction);
                    BlockEntity blockEntity = WorldHelper.getBlockEntity((BlockGetter)level, pos);
                    Direction sideHit = direction.m_122424_();
                    if (blockEntity != null && (capability = blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit).resolve()).isPresent()) {
                        ((IFluidHandler)capability.get()).fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                        return stack;
                    }
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60734_() == Blocks.f_50256_) {
                        level.m_46597_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)));
                        return stack;
                    }
                    if (state.m_60734_() == Blocks.f_152476_) {
                        if (!((LayeredCauldronBlock)state.m_60734_()).m_142596_(state)) {
                            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1)));
                            return stack;
                        }
                    } else {
                        WorldHelper.placeFluid(null, (Level)level, pos, Fluids.f_76193_, !ProjectEConfig.server.items.opEvertide.get());
                        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)PESoundEvents.WATER_MAGIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        return stack;
                    }
                    return super.m_7498_(source, stack);
                }
            });
            CauldronInteraction.f_175606_.put((Item)PEItems.EVERTIDE_AMULET.get(), (state, level, pos, player, hand, stack) -> {
                if (!level.f_46443_) {
                    level.m_46597_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            });
            CauldronInteraction.f_175607_.put((Item)PEItems.EVERTIDE_AMULET.get(), (state, level, pos, player, hand, stack) -> {
                if (((LayeredCauldronBlock)state.m_60734_()).m_142596_(state)) {
                    return InteractionResult.PASS;
                }
                if (!level.f_46443_) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1)));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            });
            CauldronInteraction.f_175606_.put((Item)PEItems.VOLCANITE_AMULET.get(), (state, level, pos, player, hand, stack) -> {
                if (!level.f_46443_ && ItemPE.consumeFuel(player, stack, 32L, true)) {
                    level.m_46597_(pos, Blocks.f_152477_.m_49966_());
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            });
            ArgumentTypes.m_121601_((String)"projecte:uuid", UUIDArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(UUIDArgument::new));
            ArgumentTypes.m_121601_((String)"projecte:color", ColorArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(ColorArgument::new));
            ArgumentTypes.m_121601_((String)"projecte:nss", NSSItemArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(NSSItemArgument::new));
        });
    }

    private static void registerDispenseBehavior(DispenseItemBehavior behavior, ItemLike ... items) {
        for (ItemLike item : items) {
            DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior);
        }
    }

    private void imcQueue(InterModEnqueueEvent event) {
        WorldTransmutations.init();
        NSSSerializer.init();
        IntegrationHelper.sendIMCMessages(event);
    }

    private void imcHandle(InterModProcessEvent event) {
        IMCHandler.handleMessages();
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof PEModConfig) {
            PEModConfig peConfig = (PEModConfig)config;
            peConfig.clearCache();
        }
    }

    private void tagsUpdated(TagsUpdatedEvent event) {
        if (this.emcUpdateResourceManager != null) {
            long start = System.currentTimeMillis();
            AbstractNSSTag.clearCreatedTags();
            CustomEMCParser.init();
            try {
                EMCMappingHandler.map(this.emcUpdateResourceManager.serverResources(), this.emcUpdateResourceManager.resourceManager());
                LOGGER.info("Registered " + EMCMappingHandler.getEmcMapSize() + " EMC values. (took " + (System.currentTimeMillis() - start) + " ms)");
                PacketHandler.sendFragmentedEmcPacketToAll();
            }
            catch (Throwable t) {
                LOGGER.error("Error calculating EMC values", t);
            }
            this.emcUpdateResourceManager = null;
        }
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
            this.emcUpdateResourceManager = new EmcUpdateData(event.getServerResources(), manager);
        }));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MODID).then(ClearKnowledgeCMD.register())).then(DumpMissingEmc.register())).then(RemoveEmcCMD.register())).then(ResetEmcCMD.register())).then(SetEmcCMD.register())).then(ShowBagCMD.register());
        event.getDispatcher().register(root);
    }

    private void serverStarting(ServerStartingEvent event) {
        if (!ThreadCheckUUID.hasRunServer()) {
            new ThreadCheckUUID(true).start();
        }
    }

    private void serverQuit(ServerStoppedEvent event) {
        CustomEMCParser.flush();
        TransmutationOffline.cleanAll();
        EMCMappingHandler.clearEmcMap();
    }

    private record EmcUpdateData(ReloadableServerResources serverResources, ResourceManager resourceManager) {
    }
}

